package cn.com.duiba.activity.center.api.remoteservice.fliggybet;

import cn.com.duiba.activity.center.api.dto.fliggybet.FliggyBetRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.math.BigDecimal;
import java.util.List;

/**
 * Created by ChenXiangge on 11/06/2018.
 */
@AdvancedFeignClient
public interface RemoteFliggyBetRecordService {
	
    Integer update(FliggyBetRecordDto fliggyBetRecordDto);

    Long insert(FliggyBetRecordDto fliggyBetRecordDto);

    List<FliggyBetRecordDto> listByConsumerId(Long consumerId);

    List<FliggyBetRecordDto> listByConsumerIdAndBetIds(Long consumerId, List<Long> betIds);
    
    void openPrize(Long betId,Integer optionId,Long shareAmount);

    /**
     * 通过shareCode查询押注记录
     * @param shareCode
     * @return
     */
    FliggyBetRecordDto findByShareCode(String shareCode);

    /**
     * 根据分享码累加红包倍数
     * @param shareCode
     * @return
     */
    Integer addMultiplyByShareCode(String shareCode);
}
