package cn.com.duiba.activity.center.api.remoteservice.ngame;

import cn.com.duiba.activity.center.api.dto.ngame.NgameMutiRankingRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 多游戏排行榜管理端接口
 * 管理端用于分页查询、标记作弊、变更分数等操作
 * Created by hww on 2018/8/9 下午3:24.
 */
@AdvancedFeignClient
public interface RemoteNgameMultiRankingRecordBackedService {


    /**
     * 标记用户作弊状态
     * 同时会操作redis 删除或插入
     */
    void markCheat(NgameMutiRankingRecordDto record);

    /**
     * 更新排行榜记录的分数
     * 同时会操作redis 更新分数
     */
    void updateScore(NgameMutiRankingRecordDto record);


    /**
     * 根据id查询
     */
    NgameMutiRankingRecordDto findById(Long id);


}
