/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.rank;

import cn.com.duiba.activity.center.api.rank.NGameRank;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Calendar;
import java.util.Date;
import org.springframework.data.redis.core.RedisTemplate;

public class NGameRankFactory {
    private static final int EXPIRE_DAYS = 10;
    private static final int MULTI_NGAME_EXPIRE_DAYS = 30;
    private static final int OPTION_RANK_EXPIRE_DAYS = 30;
    private static final int RANK_LIMIT_NUM = 5000;
    private static final int MULTI_NGAME_RANK_LIMIT_NUM = 20000;
    private static final int DAILY_RANK_EXPIRE_DAYS = 3;
    private static final int WEEKLY_RANK_EXPIRE_DAYS = 14;
    private static String K024 = "AAW_K024_";
    private static String K025 = "AAW_K025_";
    private static String K026 = "AAW_K026_";
    private static String K041 = "AAW_K041_";
    private static String K042 = "AAW_K042_";
    private static String K043 = "AAW_K043_";
    private static String K047 = "AAW_K047_";
    private static String K048 = "AAW_K048_";
    private static String K049 = "AAW_K049_";
    private static String K056 = "AAW_K056_";
    private static String K057 = "AAW_K057_";
    private static String K058 = "AAW_K058_";
    private static String K102 = "AAW_K102_";
    private static String K103 = "AAW_K103_";
    private static String K104 = "AAW_K104_";

    public static NGameRank generateTotalRank(long gameId, boolean isDesc, RedisTemplate<String, String> redisClient) {
        return new NGameRank(K024 + gameId, K025 + gameId, K026 + gameId, 10, isDesc, 5000, redisClient);
    }

    public static NGameRank generateDailyRank(long gameId, boolean isDesc, RedisTemplate<String, String> redisClient) {
        String dailyMark = DateUtils.getDayStr((Date)new Date()) + "-" + gameId;
        return new NGameRank(K041 + dailyMark, K042 + dailyMark, K043 + dailyMark, 3, isDesc, 5000, redisClient);
    }

    public static NGameRank generateYesterdayRank(long gameId, boolean isDesc, RedisTemplate<String, String> redisClient) {
        String dailyMark = DateUtils.getDayStr((Date)DateUtils.daysAddOrSub((Date)new Date(), (int)-1)) + "-" + gameId;
        return new NGameRank(K041 + dailyMark, K042 + dailyMark, K043 + dailyMark, 3, isDesc, 5000, redisClient);
    }

    public static NGameRank generateMultiNGameTotalRank(Long appId, Long rankId, boolean isDesc, RedisTemplate<String, String> redisClient) {
        String key = rankId + "-" + appId;
        return new NGameRank(K047 + key, K048 + key, K049 + key, 30, isDesc, 20000, redisClient);
    }

    public static NGameRank generateOptionNumRank(Long appId, Long rankId, boolean distinctByApp, boolean isDesc, RedisTemplate<String, String> redisClient) {
        String key = String.valueOf(rankId);
        if (distinctByApp) {
            key = key + "-" + appId;
        }
        return new NGameRank(K056 + key, K057 + key, K058 + key, 30, isDesc, 5000, redisClient);
    }

    public static NGameRank generateWeeklyRank(long gameId, boolean isDesc, RedisTemplate<String, String> redisClient) {
        String weeklyMark = NGameRankFactory.getWeekMark(new Date()) + "-" + gameId;
        return new NGameRank(K102 + weeklyMark, K103 + weeklyMark, K104 + weeklyMark, 14, isDesc, 5000, redisClient);
    }

    public static NGameRank generateLastWeekRank(long gameId, boolean isDesc, RedisTemplate<String, String> redisClient) {
        String weeklyMark = NGameRankFactory.getWeekMark(DateUtils.daysAddOrSub((Date)new Date(), (int)-7)) + "-" + gameId;
        return new NGameRank(K102 + weeklyMark, K103 + weeklyMark, K104 + weeklyMark, 14, isDesc, 5000, redisClient);
    }

    private static int getWeekMark(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        return calendar.get(3);
    }
}

