package cn.com.duiba.activity.center.api.dto;

import cn.com.duiba.activity.center.api.enums.ActCenterErrorCodeEnum;

import java.io.Serializable;

/**
 * 业务不想抛异常,想通过带错误消息给调用方的方式可以使用该dto传输
 * <p>
 * Created by sunchangji on 2018/5/15.
 */
public class BizResultDto<T> implements Serializable {

    private static final long serialVersionUID = 5146589033393315686L;

    // 调用是否成功
    private boolean success = true;

    // 调用结果信息,可以放异常的message.
    private String msg;

    // 返回码
    private String code;

    // 调用结果
    private T result;

    public BizResultDto() {

    }

    /**
     * 快速构建成功返回对象
     *
     * @param result 返回结果
     * @return
     */
    public static <T> BizResultDto successResult(T result) {
        BizResultDto<T> bizResult = new BizResultDto<>();
        bizResult.setResult(result);
        bizResult.setSuccess(true);
        bizResult.setMsg(ActCenterErrorCodeEnum.C_00000000.getMsg());
        bizResult.setCode(ActCenterErrorCodeEnum.C_00000000.getCode());
        return bizResult;
    }

    /**
     * 快速构建成功返回对象
     *
     * @return
     */
    public static <T> BizResultDto success() {
        BizResultDto<T> bizResult = new BizResultDto<>();
        bizResult.setSuccess(true);
        bizResult.setMsg(ActCenterErrorCodeEnum.C_00000000.getMsg());
        bizResult.setCode(ActCenterErrorCodeEnum.C_00000000.getCode());
        return bizResult;
    }

    /**
     * 快速构建失败返回对象
     *
     * @param codeEnum 失败信息
     * @param <T>
     * @return
     */
    public static <T> BizResultDto<T> failResult(ActCenterErrorCodeEnum codeEnum) {
        BizResultDto<T> bizResult = new BizResultDto<>();
        bizResult.setSuccess(false);
        bizResult.setMsg(codeEnum.getMsg());
        bizResult.setCode(codeEnum.getCode());
        return bizResult;
    }

    /**
     * 快速构建失败返回对象
     *
     * @param msg 失败信息
     * @param <T>
     * @return
     */
    public static <T> BizResultDto<T> failMsg(String msg) {
        BizResultDto<T> bizResult = new BizResultDto<>();
        bizResult.setSuccess(false);
        bizResult.setMsg(msg);
        bizResult.setCode(ActCenterErrorCodeEnum.C_99999999.getCode());
        return bizResult;
    }

    public static <T> BizResultDto<T> builder() {
        return new BizResultDto<>();
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }
}
