package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.exception.ActivityCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * 补签消耗类型
 * Created by xiaoxuda on 2017/8/10.
 */
public enum ReSignConsumeTypeEnum {
    NO(0, "无"),
    CREDITS(1, "积分"),
    RESIGN_CARD(2, "补签卡");

    private static Map<Integer, ReSignConsumeTypeEnum> valueMap = new HashMap<>();
    static{
        for(ReSignConsumeTypeEnum typeEnum : values()){
            valueMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    private Integer code;
    private String desc;

    ReSignConsumeTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static ReSignConsumeTypeEnum getByCode(Integer code){
        ReSignConsumeTypeEnum typeEnum = valueMap.get(code);
        if(typeEnum == null){
            throw new ActivityCenterException("非法的补签消耗类型，code=" + code);
        }
        return typeEnum;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
