package cn.com.duiba.activity.center.api.dto.seedredpacket;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author zhengjianhao
 * @date 18/7/5
 * @description 种红包
 */
public class SeedRedPacketDto implements Serializable {

	private static final long serialVersionUID = -3258354801603374791L;

	/** 关闭 */
	public static final int STATUS_CLOSE = 0;
	/** 开启 */
	public static final int STATUS_OPEN = 1;

	/**
	 * 活动id
	 */
	private Long id;

	/**
	 * 标题
	 */
	private String title;

	/**
	 * 种红包所需积分价值
	 */
	private Long seedCreditsPrice;

	/**
	 * 解锁4号土地所需积分价值
	 */
	private Long unlockLandCreditsPrice;

	/**
	 * 是否开启：0，关闭；1，开启
	 */
	private Integer status;

	/**
	 * 创建时间
	 */
	private Date gmtCreate;

	/**
	 * 红包成长时间列表
	 */
	private List<SeedRedPacketGrownTimeDto> grownTimeList;

	/**
	 * 活动规则
	 */
	private String rule;

	/**
	 * 广告开关
	 */
	private Boolean adSwitch;

	/**
	 * 广告位置
	 */
	private String adPositions;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Long getSeedCreditsPrice() {
		return seedCreditsPrice;
	}

	public void setSeedCreditsPrice(Long seedCreditsPrice) {
		this.seedCreditsPrice = seedCreditsPrice;
	}

	public Long getUnlockLandCreditsPrice() {
		return unlockLandCreditsPrice;
	}

	public void setUnlockLandCreditsPrice(Long unlockLandCreditsPrice) {
		this.unlockLandCreditsPrice = unlockLandCreditsPrice;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public List<SeedRedPacketGrownTimeDto> getGrownTimeList() {
		return grownTimeList;
	}

	public void setGrownTimeList(List<SeedRedPacketGrownTimeDto> grownTimeList) {
		this.grownTimeList = grownTimeList;
	}

	public Boolean getAdSwitch() {
		return adSwitch;
	}

	public void setAdSwitch(Boolean adSwitch) {
		this.adSwitch = adSwitch;
	}

	public String getAdPositions() {
		return adPositions;
	}

	public void setAdPositions(String adPositions) {
		this.adPositions = adPositions;
	}

	public String getRule() {
		return rule;
	}

	public void setRule(String rule) {
		this.rule = rule;
	}

	// 根据红包序号获取红包成熟所需时间
	public Long getGrownTime(Integer redPacketNumber){
		for(SeedRedPacketGrownTimeDto grownTime: grownTimeList){
			if(grownTime.getRedPacketId().equals(redPacketNumber)){
				return grownTime.getGrownTime();
			}
		}
		return null;
	}
}
