package cn.com.duiba.activity.center.api.rank;

import cn.com.duiba.activity.center.api.tool.RedisKeySpace;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * 游戏排行榜工厂方法
 * Created by hww on 2018/8/9 下午4:36.
 */
public class NGameRankFactory {

    /**
     * 多游戏总排名redis缓存时间
     */
    private static final int MULTI_NGAME_EXPIRE_DAYS = 30;

    /**
     * 多游戏排行榜排名限制数
     */
    private static final int MULTI_NGAME_RANK_LIMIT_NUM = 20000;

    /**
     * 获取多游戏总排行榜
     */
    public static NGameRank generateMultiNGameTotalRank(Long id, Long subId, boolean isDesc, RedisTemplate<String, String> redisClient) {
        String key = id + "-" + subId;
        return new NGameRank (
                RedisKeySpace.K093.toString() + key,
                RedisKeySpace.K094.toString() + key,
                RedisKeySpace.K095.toString() + key,
                MULTI_NGAME_EXPIRE_DAYS,
                isDesc,
                MULTI_NGAME_RANK_LIMIT_NUM,
                redisClient
        );
    }

}
