package cn.com.duiba.activity.center.api.dto.luckycode;

import cn.com.duiba.activity.center.api.enums.LuckyCodeAwardTypeEnum;

import java.io.Serializable;

/**
 * 幸运码活动奖品配置Dto
 * author zhanghuifeng
 * date 2019-03-20-17:16
 */
public class LuckyCodeAwardConfigDto implements Serializable {
    private static final long serialVersionUID = 2034320570643790677L;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 奖品ID
     */
    private Long appItemId;

    /**
     * 第几天的奖品
     */
    private Integer dateNum;

    /**
     * 奖品类型;1优惠券,2虚拟商品,3实物,4直冲
     * @see LuckyCodeAwardTypeEnum
     */
    private Integer appItemType;

    /**
     *奖品名称
     */
    private String awardName;

    /**
     * 奖品数
     */
    private Integer awardTotal;

    /**
     * 剩余奖品数
     */
    private Integer surplusAwardTotal;

    /**
     * 未知抽奖码个数
     */
    private Integer unknownCodeTotal;

    /**
     * 幸运码
     */
    private Long luckyCode;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Integer getDateNum() {
        return dateNum;
    }

    public void setDateNum(Integer dateNum) {
        this.dateNum = dateNum;
    }

    public Integer getAppItemType() {
        return appItemType;
    }

    public void setAppItemType(Integer appItemType) {
        this.appItemType = appItemType;
    }

    public String getAwardName() {
        return awardName;
    }

    public void setAwardName(String awardName) {
        this.awardName = awardName;
    }

    public Integer getAwardTotal() {
        return awardTotal;
    }

    public void setAwardTotal(Integer awardTotal) {
        this.awardTotal = awardTotal;
    }

    public Integer getSurplusAwardTotal() {
        return surplusAwardTotal;
    }

    public void setSurplusAwardTotal(Integer surplusAwardTotal) {
        this.surplusAwardTotal = surplusAwardTotal;
    }

    public Integer getUnknownCodeTotal() {
        return unknownCodeTotal;
    }

    public void setUnknownCodeTotal(Integer unknownCodeTotal) {
        this.unknownCodeTotal = unknownCodeTotal;
    }

    public Long getLuckyCode() {
        return luckyCode;
    }

    public void setLuckyCode(Long luckyCode) {
        this.luckyCode = luckyCode;
    }
}
