package cn.com.duiba.activity.center.api.dto.luckycode;

import cn.com.duiba.activity.center.api.enums.LuckyCodeUserScratchStateEnum;

import java.io.Serializable;

/**
 * 幸运码用户刮奖记录Dto
 * author zhanghuifeng
 * date 2019-03-20-17:21
 */
public class LuckyCodeUserScratchRecordDto implements Serializable {
    private static final long serialVersionUID = 1370356092549744078L;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动奖品配置ID
     */
    private Long awardConfigId;

    /**
     * 抽奖码,例如:[1, 2, 3, 4, 5,6,7,8,9]
     */
    private String lotteryCode;

    /**
     * 扣积分订单ID
     */
    private Long orderId;

    /**
     * 消耗积分
     */
    private Long credits;

    /**
     * 状态;1已刮数字,0未刮数字
     * @see LuckyCodeUserScratchStateEnum
     */
    private Integer state;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getAwardConfigId() {
        return awardConfigId;
    }

    public void setAwardConfigId(Long awardConfigId) {
        this.awardConfigId = awardConfigId;
    }

    public String getLotteryCode() {
        return lotteryCode;
    }

    public void setLotteryCode(String lotteryCode) {
        this.lotteryCode = lotteryCode;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
}
