package cn.com.duiba.activity.center.api.enums;

/**
 * 幸运码用户刮奖状态
 * author zhanghuifeng
 * date 2019-03-20-16:18
 */
public enum LuckyCodeUserScratchStateEnum {

    FINISH_SCRATCH(1, "已刮数字"),
    UN_FINISH_SCRATCH(0, "未刮数字"),
    ;


    private Integer code;
    private String desc;

    LuckyCodeUserScratchStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LuckyCodeUserScratchStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (LuckyCodeUserScratchStateEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
