package cn.com.duiba.activity.center.api.dto.bargain;

import cn.com.duiba.activity.center.api.enums.BargainOrderStatusEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * @author author
 */
public class BargainOrderDto implements Serializable {

    private static final long serialVersionUID = -7710553786840001935L;
    /**
     * 主键
     * 物理主键
     * isNullAble:0
     */
    private Long id;

    /**
     * 用户id
     * isNullAble:0
     */
    private Long consumerId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 砍价活动id,来源tb_bargain_activity_info.id
     * isNullAble:0
     */
    private Long bargainActivityId;

    /**
     * 砍价商品信息id,来源tb_bargain_item_info.id
     * isNullAble:0
     */
    private Long bargainItemId;

    /**
     * 商品名称
     */
    private String itemName;

    /**
     * 商品图片url
     */
    private String imageUrl;

    /**
     * 市场价，精确到分
     * isNullAble:0
     */
    private Integer marketPrice;

    /**
     * 已砍金额
     */
    private Integer totalBargainPrice;

    /**
     * 砍价订单状态
     */
    private BargainOrderStatusEnum bargainStatus;

    /**
     * 砍价结束时间
     * isNullAble:0
     */
    private Date bargainEndTime;

    /**
     * 修改时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 创建时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getBargainActivityId() {
        return bargainActivityId;
    }

    public void setBargainActivityId(Long bargainActivityId) {
        this.bargainActivityId = bargainActivityId;
    }

    public Long getBargainItemId() {
        return bargainItemId;
    }

    public void setBargainItemId(Long bargainItemId) {
        this.bargainItemId = bargainItemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public Integer getMarketPrice() {
        return marketPrice;
    }

    public void setMarketPrice(Integer marketPrice) {
        this.marketPrice = marketPrice;
    }

    public Integer getTotalBargainPrice() {
        return totalBargainPrice;
    }

    public void setTotalBargainPrice(Integer totalBargainPrice) {
        this.totalBargainPrice = totalBargainPrice;
    }

    public BargainOrderStatusEnum getBargainStatus() {
        return bargainStatus;
    }

    public void setBargainStatus(BargainOrderStatusEnum bargainStatus) {
        this.bargainStatus = bargainStatus;
    }

    public Date getBargainEndTime() {
        return bargainEndTime;
    }

    public void setBargainEndTime(Date bargainEndTime) {
        this.bargainEndTime = bargainEndTime;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
}
