package cn.com.duiba.activity.center.api.enums.centscan;

/**
 * Created by sunyan on 2019/10/9.
 */
public enum CardTypeEnum {
    CARD_DEBIT("DEBIT", "借记卡"),
    CARD_CREDIT("CREDIT", "信用卡"),
    ;


    private String code;
    private String desc;

    CardTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CardTypeEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        for (CardTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
