package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.exception.ActivityCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * 星座类型
 * Created by xiaoxuda on 2017/4/20.
 */
public enum ConstellationTypeEnum {
    CAPRICORN(1, "摩羯座", "12.22", "01.19"),
    AQUARIUS(2, "水瓶座", "01.20", "02.18"),
    PISCES(3, "双鱼座", "02.19", "03.20"),
    ARIES(4, "白羊座", "03.21", "04.20"),
    TAURUS(5, "金牛座", "04.21", "05.20"),
    GEMINI(6, "双子座", "05.21", "06.21"),
    CANCER(7, "巨蟹座", "06.22", "07.22"),
    LEO(8, "狮子座", "07.23", "08.22"),
    VIRGO(9, "处女座", "08.23", "09.22"),
    LIBRA(10, "天秤座", "09.23", "10.22"),
    SCORPIO(11, "天蝎座", "10.23", "11.21"),
    SAGITTARIUS(12, "射手座", "11.22", "12.21");

    private Integer code;
    private String desc;
    private String startDay;
    private String endDay;

    private static Map<Integer, ConstellationTypeEnum> typeMap = new HashMap<>();

    static {
        for (ConstellationTypeEnum typeEnum : values()) {
            typeMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    ConstellationTypeEnum(Integer code, String desc, String startDay, String endDay) {
        this.code = code;
        this.desc = desc;
        this.startDay = startDay;
        this.endDay = endDay;
    }

    /**
     * 根据code换取星座类型
     * @param code
     * @return
     */
    public static ConstellationTypeEnum getByCode(Integer code) {
        if (code == null || !typeMap.containsKey(code)) {
            throw new ActivityCenterException("错误的星座类型,code=" + code);
        }
        return typeMap.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getStartDay() {
        return startDay;
    }

    public String getEndDay() {
        return endDay;
    }
}
