package cn.com.duiba.activity.center.api.enums.creditsfarm;

/**
 * 种植状态：0-初始化 1-成功 2-失败
 */
public enum ExchangeStatusEnum {
    EXCHANGE_STATUS_INIT(0, "初始化"),
    EXCHANGE_STATUS_SUC(1, "成功"),
    EXCHANGE_STATUS_FAIL(2, "失败"),
    ;


    private Integer code;
    private String desc;

    ExchangeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ExchangeStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ExchangeStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
