package cn.com.duiba.activity.center.api.remoteservice.ngame;

import cn.com.duiba.activity.center.api.dto.ngame.NgameMutiRankingBaseConfigDto;
import cn.com.duiba.activity.center.api.params.NgameMutiRankingBaseConfigQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by sty on 12/9/17.
 */
@AdvancedFeignClient
public interface RemoteNgameMutiRankingBaseConfigService {

    /**查询配置项基本信息
     *
     * @param id
     * @return
     */
    NgameMutiRankingBaseConfigDto findByBaseConfigId(Long id);

    /**删除配置项
     *
     * @param id
     * @return
     */
    int deleteByBaseConfigId(Long id);

    /**
     * 配置项开启和关闭开关切换
     * @param id
     * @param switchOn
     * @return
     */
    int switchByBaseConfigId(Long id,Boolean switchOn);

    /**
     * 查询开启的游戏配置项数量
     * @return
     */
    int findOpenedBaseConfigNum();

    /**
     * 分页查询计算总数
     * @param ngameMutiRankingBaseConfigQueryParam
     * @return
     */
    Long countBaseConfigByPage(NgameMutiRankingBaseConfigQueryParam ngameMutiRankingBaseConfigQueryParam);

    /**
     * 分页查询多排名的基本配置
     * @param ngameMutiRankingBaseConfigQueryParam
     * @return
     */
    List<NgameMutiRankingBaseConfigDto> findBaseConfigByPage(NgameMutiRankingBaseConfigQueryParam ngameMutiRankingBaseConfigQueryParam);

    /**
     * 手机端调用方法,手机端记得做缓存，本地缓存，没有会返回null
     * @param duibaNgameId
     * @return
     */
    Long findBaseConfigIdByNgameId(Long duibaNgameId);

    /** 开奖 */
    int openPrize(Long id);


}
