package cn.com.duiba.activity.center.api.enums.happycodenew;

/**
 * @Author chenxiangge
 * @Date 2019/4/1
 */
public enum ItemBasicStatusEnum {
    INIT(-1, "未开启"),
    PROCESS(0, "进行中"),
    FINISHED(1, "已结束"),
    PRIZE_ERROR(2, "奖项异常");

    private Integer code;
    private String desc;

    ItemBasicStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ItemBasicStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ItemBasicStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }


    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
