package cn.com.duiba.activity.center.api.dto.joingroup;

import java.io.Serializable;

/**
 * @author zhengjianhao
 * @date 18/9/14
 * @description 拼团活动商品配置表
 */
public class JoinGroupItemDto implements Serializable {

	private static final long serialVersionUID = -3486784546879665256L;
	/**
	 * 拼团商品id
	 */
	private Long id;

	/**
	 * 拼团商品名称
	 */
	private String itemName;

	/**
	 * 拼团活动id
	 */
	private Long joinGroupConfigId;

	/**
	 * 兑换项id
	 */
	private Long itemId;

	/**
	 * 兑换项类型
	 */
	private String prizeType;

	/**
	 * 过期时间(秒)
	 */
	private Long expiredTime;

	/**
	 * 成团人数
	 */
	private Integer groupNumber;

	/**
	 * 剩余库存数量
	 */
	private Integer remaining;

	/**
	 * 价值
	 */
	private Long facePrice;

	/**
	 * 作弊规则：1，全部团作弊；2，随机选团作弊；3，不作弊
	 * @see cn.com.duiba.activity.center.api.enums.JoinGroupCheatTypeEnum
	 */
	private Integer cheatRuleType;

	/**
	 * 随机作弊概率
	 */
	private Integer cheatPercent;

	/**
	 * 开团限制类型：0，每天；1，永久
	 * @see cn.com.duiba.activity.center.api.enums.LimitScopeEnum
	 */
	private Integer openLimitType;

	/**
	 * 开团限制次数，没有则无限制
	 */
	private Integer openLimit;

	/**
	 * 参团限制类型：0，每天；1，永久
	 * @see cn.com.duiba.activity.center.api.enums.LimitScopeEnum
	 */
	private Integer joinLimitType;

	/**
	 * 参团限制次数，没有则无限制
	 */
	private Integer joinLimit;

	/**
	 * 是否启用：0，禁用；1，启用
	 */
	private Integer itemStatus;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getItemName() {
		return itemName;
	}

	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public Long getJoinGroupConfigId() {
		return joinGroupConfigId;
	}

	public void setJoinGroupConfigId(Long joinGroupConfigId) {
		this.joinGroupConfigId = joinGroupConfigId;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public String getPrizeType() {
		return prizeType;
	}

	public void setPrizeType(String prizeType) {
		this.prizeType = prizeType;
	}

	public Long getExpiredTime() {
		return expiredTime;
	}

	public void setExpiredTime(Long expiredTime) {
		this.expiredTime = expiredTime;
	}

	public Integer getGroupNumber() {
		return groupNumber;
	}

	public void setGroupNumber(Integer groupNumber) {
		this.groupNumber = groupNumber;
	}

	public Integer getRemaining() {
		return remaining;
	}

	public void setRemaining(Integer remaining) {
		this.remaining = remaining;
	}

	public Long getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(Long facePrice) {
		this.facePrice = facePrice;
	}

	public Integer getCheatRuleType() {
		return cheatRuleType;
	}

	public void setCheatRuleType(Integer cheatRuleType) {
		this.cheatRuleType = cheatRuleType;
	}

	public Integer getCheatPercent() {
		return cheatPercent;
	}

	public void setCheatPercent(Integer cheatPercent) {
		this.cheatPercent = cheatPercent;
	}

	public Integer getOpenLimitType() {
		return openLimitType;
	}

	public void setOpenLimitType(Integer openLimitType) {
		this.openLimitType = openLimitType;
	}

	public Integer getOpenLimit() {
		return openLimit;
	}

	public void setOpenLimit(Integer openLimit) {
		this.openLimit = openLimit;
	}

	public Integer getJoinLimitType() {
		return joinLimitType;
	}

	public void setJoinLimitType(Integer joinLimitType) {
		this.joinLimitType = joinLimitType;
	}

	public Integer getJoinLimit() {
		return joinLimit;
	}

	public void setJoinLimit(Integer joinLimit) {
		this.joinLimit = joinLimit;
	}

	public Integer getItemStatus() {
		return itemStatus;
	}

	public void setItemStatus(Integer itemStatus) {
		this.itemStatus = itemStatus;
	}
}
