package cn.com.duiba.activity.center.api.mqmessage;

import cn.com.duiba.activity.center.api.dto.group.GroupActivityRecordDto;
import cn.com.duiba.wolf.utils.GZIPUtils;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.List;

/**
 * @description: 搜狐资讯数据同步消息类
 * 接收消息通调用静态方法decode()获取回调对象
 * @author: zhengwei
 * @date: 2018-08-08 20:48
 */
public class SouhuTeamDataAccessMsg implements Serializable {
    private static final long serialVersionUID = 489538413843650129L;

    public static final int insert = 0;
    public static final int update = 1;

    /**
     * 操作类型(0:插入;1:更新)
     */
    private Integer operateType;

    /**
     * 搜狐组团活动数据待操作列表
     */
    private List<GroupActivityRecordDto> list;


    public Integer getOperateType() {
        return operateType;
    }

    public void setOperateType(Integer operateType) {
        this.operateType = operateType;
    }

    public List<GroupActivityRecordDto> getList() {
        return list;
    }

    public void setList(List<GroupActivityRecordDto> dtoList) {
        this.list = dtoList;
    }

    public static SouhuTeamDataAccessMsg decode(byte[] msg) {
        String string = GZIPUtils.ungzip(msg);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JSONObject.parseObject(string, SouhuTeamDataAccessMsg.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param msg
     * @return
     */
    public static byte[] encode(SouhuTeamDataAccessMsg msg) {
        String string = JSONObject.toJSONString(msg);
        return GZIPUtils.gzip(string);
    }
}
