package cn.com.duiba.activity.center.api.dto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import static cn.com.duiba.activity.center.api.enums.UploadImageEnum.BANNER_IMAGE_NEW;
import static cn.com.duiba.activity.center.api.enums.UploadImageEnum.SMALL_IMAGE_NEW;

/**
 * 基础活动DTO
 * Created by xutao on 2017/7/6.
 */
public abstract class BaseActivityDto implements Serializable {

    private static final long serialVersionUID = 7077604460392740053L;

    //json图片字符串
    protected String imageJson;

    //新版首页banner
    protected String bannerImgNew;
    //新版缩略图
    protected String smallImgNew;

    private Map<String, String> imageJsonMap = Maps.newHashMap();

    public String getImageJson() {
        return imageJson;
    }

    public void setImageJson(String imageJson) {
        this.imageJson = imageJson;
    }

    public String getImageJsonMap() {
        return JSON.toJSONString(imageJsonMap);
    }

    public void setImageJsonMap(Map<String, String> imageJsonMap) {
        this.imageJsonMap = imageJsonMap;
    }

    public String getBannerImgNew() {
        if (StringUtils.isNotBlank(this.imageJson)) {
            return JSON.parseObject(imageJson, new TypeReference<Map<String, String>>() {
            }).get(BANNER_IMAGE_NEW.getCode());
        }

        return StringUtils.EMPTY;
    }


    public void setBannerImgNew(String bannerImgNew) {
        this.bannerImgNew = bannerImgNew;
        imageJsonMap.put(BANNER_IMAGE_NEW.getCode(), bannerImgNew);
    }

    public String getSmallImgNew() {
        if (StringUtils.isNotBlank(this.imageJson)) {
            return JSON.parseObject(imageJson, new TypeReference<Map<String, String>>() {
            }).get(SMALL_IMAGE_NEW.getCode());
        }

        return StringUtils.EMPTY;
    }

    public void setSmallImgNew(String smallImgNew) {
        this.smallImgNew = smallImgNew;
        imageJsonMap.put(SMALL_IMAGE_NEW.getCode(), smallImgNew);
    }

    public static BaseActivityDto addImgNew(BaseActivityDto dto) {
        if (dto == null) {
            return null;
        }

        //解析json string并设置相应值
        dto.setSmallImgNew(dto.getSmallImgNew());
        dto.setBannerImgNew(dto.getBannerImgNew());
        return dto;
    }

    public static void addImgNewList(List<? extends BaseActivityDto> dtoList) {
        if (CollectionUtils.isNotEmpty(dtoList)) {
            for (BaseActivityDto dto : dtoList) {
                addImgNew(dto);
            }
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
