package cn.com.duiba.activity.center.api.dto.joingroup;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhengjianhao
 * @date 18/9/14
 * @description 拼团活动配置信息
 */
public class JoinGroupConfigDto implements Serializable {

	private static final long serialVersionUID = -2662162738495794564L;
	/**
	 * 拼团活动id
	 */
	private Long id;

	/**
	 * 标题
	 */
	private String title;

	/**
	 * 其他团数量
	 */
	private Integer otherGroupCount;

	/**
	 * 关联自定义活动id-活动列表
	 */
	private Long relateActList;

	/**
	 * 关联自定义活动id-活动详情
	 */
	private Long relateActDetail;

	/**
	 * 策划人
	 */
	private String plannerName;

	/**
	 * 团员参与奖励，对应插件id
	 */
	private Long joinAward;

	/**
	 * 团长开团奖励，对应插件id
	 */
	private Long openAward;

	/**
	 * 分享奖励，对应插件id
	 */
	private Long shareAward;

	/**
	 * 拼团类型：1，免费拼团
	 */
	private Integer activityType;

	/**
	 * 是否开启：0，关闭；1，开启
	 */
	private Integer activityStatus;

	/**
	 * 拼团商品列表
	 */
	private List<JoinGroupItemDto> joinGroupItemList;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getOtherGroupCount() {
		return otherGroupCount;
	}

	public void setOtherGroupCount(Integer otherGroupCount) {
		this.otherGroupCount = otherGroupCount;
	}

	public Long getRelateActList() {
		return relateActList;
	}

	public void setRelateActList(Long relateActList) {
		this.relateActList = relateActList;
	}

	public Long getRelateActDetail() {
		return relateActDetail;
	}

	public void setRelateActDetail(Long relateActDetail) {
		this.relateActDetail = relateActDetail;
	}

	public String getPlannerName() {
		return plannerName;
	}

	public void setPlannerName(String plannerName) {
		this.plannerName = plannerName;
	}

	public Long getJoinAward() {
		return joinAward;
	}

	public void setJoinAward(Long joinAward) {
		this.joinAward = joinAward;
	}

	public Long getOpenAward() {
		return openAward;
	}

	public void setOpenAward(Long openAward) {
		this.openAward = openAward;
	}

	public Long getShareAward() {
		return shareAward;
	}

	public void setShareAward(Long shareAward) {
		this.shareAward = shareAward;
	}

	public Integer getActivityType() {
		return activityType;
	}

	public void setActivityType(Integer activityType) {
		this.activityType = activityType;
	}

	public Integer getActivityStatus() {
		return activityStatus;
	}

	public void setActivityStatus(Integer activityStatus) {
		this.activityStatus = activityStatus;
	}

	public List<JoinGroupItemDto> getJoinGroupItemList() {
		return joinGroupItemList;
	}

	public void setJoinGroupItemList(List<JoinGroupItemDto> joinGroupItemList) {
		this.joinGroupItemList = joinGroupItemList;
	}
}
