package cn.com.duiba.activity.center.api.remoteservice.pyramidspread;

import cn.com.duiba.activity.center.api.dto.pyramidspread.PyramidSpreadConfigDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 师徒体系远程服务
 * Created by HePeng on 2019/04/19 11:29.
 */
@AdvancedFeignClient
public interface RemotePyramidSpreadService {
    /**
     * 保存师徒活动配置（包含新增/修改）
     * @param configDto
     * @return
     */
    Long savePyramidSpreadConfig(PyramidSpreadConfigDto configDto) throws BizException;


    /**
     * 通过配置id获取师徒活动配置
     * @param id
     * @return
     */
    PyramidSpreadConfigDto getPyramidSpreadConfigById(Long id);

    /**
     * 通过活动id获取师徒活动配置
     * @param actId
     * @return
     */
    PyramidSpreadConfigDto getPyramidSpreadConfigByActId(Long actId);

    /**
     * 预加载师徒活动太阳码
     * @param activityId 活动id
     * @param activityAId 活动aid
     */
    void preLoadCode(String activityId, Long count, Long appId, String activityAId);

    /**
     * 查询用户太阳码图片
     * @param consumerId 用户id
     * @return 太阳码
     */
    String queryUserCodeImg(String activityId, Long consumerId);

    /**
     * 通过太阳码查询用户
     */
    String queryUserBySunCode(String activityCode, String code);

    /**
     * 绑定用户太阳码
     * @param activityAId 活动aid
     * @param consumerId 用户id
     * @return 太阳码
     */
    String bindUserCode(String activityId, Long consumerId, String activityAId, Long appId);

    /**
     * 查询太阳码剩余数量
     * @param activityId  活动id
     * @return count
     */
    Long queryLessCodeCount(String activityId);
}
