package cn.com.duiba.activity.common.center.api.enums;

/**
 * ClassName:ActivityComCenterErrorEnum<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 错误码 统一定义   规范参考http://cf.dui88.com/pages/viewpage.action?pageId=7676317
 * @date 创建时间：2018/3/14  11:23
 * @since JDK 1.8
 **/
public enum ActivityComCenterErrorEnum {
    CODE_2002001001("2002001001","活动工具配置获取异常"),
    CODE_2002001002("2002001002","ABtest配置查询异常"),
    CODE_2002001003("2002001003","弹层皮肤配置查询异常"),
    CODE_2002001004("2002001004","皮肤配置查询异常"),
    CODE_2002002001("2002002001","获取分享码参数异常"),
    CODE_2002002002("2002002002","调用idmake异常"),
    CODE_2002002003("2002002003", "新增分享码规则集参数异常"),
    CODE_2002002004("2002002004", "删除分享码规则集参数异常"),
    CODE_2002002005("2002002005", "新增分享码规则参数异常"),
    CODE_2002002006("2002002006", "更新分享码规则参数异常"),
    CODE_2002002007("2002002007", "缺少id"),
    CODE_2002002008("2002002008", "缺少规则集id"),
    CODE_2002002009("2002002009", "官方分享码参数异常"),
    CODE_2002002010("2002002010", "一个活动只能创建一个分享码规则集"),
    CODE_2002002011("2002002011", "一个分享码规则集只能创建一种用户人群的规则"),
    CODE_2002002012("2002002012", "使用分享码参数异常"),
    CODE_2002002013("2002002013", "分享码无效，请输入正确的分享码！"),
    CODE_2002002014("2002002014", "不能重复助力！"),
    CODE_2002002015("2002002015", "分享码不存在"),
    CODE_2002002016("2002002016", "不能邀请自己"),
    CODE_2002002017("2002002017", "获取分享码规则集参数异常"),
    CODE_2002002018("2002002018","获取用户id参数异常"),
    CODE_2002002019("2002002019", "非法官方邀请码"),
    CODE_2002002021("2002002021", "新增奖励记录参数异常"),
    CODE_2002002022("2002002022", "更新奖励记录参数异常"),
    CODE_2002002023("2002002023", "获取奖励记录参数异常"),
    CODE_2002002024("2002002024", "参数错误"),
    CODE_2002002025("2002002025", "超过助力次数"),
    CODE_2002002026("2002002026", "邀请码使用超过次数"),
    CODE_2002002027("2002002027", "邀请码次数限制配置错误"),
    CODE_2002002028("2002002028", "余额变更失败"),
    CODE_2002002029("2002002029", "提现订单编号不存在"),
    CODE_2002002030("2002002030", "提现订单更新失败"),
    CODE_2002002031("2002002031", "新增余额账户失败"),
    CODE_2002002032("2002002032", "提现失败，余额不足"),
    CODE_2002002033("2002002033", "提现账户不存在"),
    CODE_2002002034("2002002034", "缺少师傅奖励"),
    CODE_2002002035("2002002035", "缺少奖励配置"),
    CODE_2002002036("2002002036", "单个好友助力上限"),
    CODE_2002002037("2002002037", "单个IP助力人数上限"),
    CODE_2002003001("2002003001", "集卡助力规则异常"),
    CODE_2002004001("2002004001","黑名单查询异常"),
    CODE_2002004002("2002004002","定向查询异常"),
    CODE_2002004003("2002004003","黑名单定向查询异常"),


    CODE_2002005001("2002005001","流量策略参数不正确"),
    CODE_2002005002("2002005002","流量策略获取异常"),
    CODE_2002006001("2002006001", "增加活动参与次数参数错误"),

    //全局账户  CODE_2002007XXX
    CODE_2002007001("2002007001", "账号类型不存在"),
    CODE_2002007002("2002007002", "兑吧用户id不合法"),
    CODE_2002007003("2002007003", "应用id不合法"),
    CODE_2002007004("2002007004", "开发者用户id不合法"),
    CODE_2002007005("2002007005", "账户变动请求不能为空"),
    CODE_2002007006("2002007006", "账户变动大类不存在"),
    CODE_2002007007("2002007007", "账户变动业务类型不存在"),
    CODE_2002007008("2002007008", "账户变动业务订单号不能为空"),
    CODE_2002007009("2002007009", "账户变动业务描述不能为空"),
    CODE_2002007010("2002007010", "账户变动金额不合法"),
    CODE_2002007011("2002007011", "账户变动类型不合法"),
    CODE_2002007012("2002007012", "查询全局钱包异常"),
    CODE_2002007013("2002007012", "账户余额不足"),


    CODE_2002008001("2002008001", "查询活动剩余次数异常"),
    CODE_2002008002("2002008002", "活动增加次数异常"),

    CODE_2002009001("2002009001", "兑吧用户id不合法"),
    CODE_2002009002("2002009002", "应用id不合法"),
    CODE_2002009003("2002009003", "增加经验请求不能为空"),
    CODE_2002009004("2002009004", "经验来源不合法"),
    CODE_2002009005("2002009005", "经验值不合法"),
    CODE_2002009006("2002009006", "获取经验获取/消耗配置异常"),
    CODE_2002009007("2002009007", "获取经验体系异常"),
    CODE_2002009008("2002009008", "插入经验流水异常"),
    CODE_2002009009("2002009009", "经验获取方式为空"),
    CODE_2002009010("2002009010", "获取经验等级配置异常"),
    CODE_2002009011("2002009011", "创建经验账户失败"),
    CODE_2002009012("2002009012", "超过用户本日增加经验上限"),

    CODE_2002011001("2002011001", "业务id不合法"),
    CODE_2002011002("2002011002", "业务类型不合法"),
    CODE_2002011003("2002011003", "排名总数不能为空"),
    CODE_2002011004("2002011004", "兑吧用户id不合法"),
    
    CODE_2002012001("2002012001", "查询入库活动失败"),

    CODE_2002010001("2002010001", "服务器内部错误"),
    ;
    //错误码
    private String code;
    //错误信息
    private String msg;


    ActivityComCenterErrorEnum(String code,String msg){
        this.code =code;
        this.msg =msg;
    }
    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
