package cn.com.duiba.activity.common.center.api.constants;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复<br>
 * 用法：枚举_业务参数
 * 生成的key前缀为：ACTCOMMC_K001_
 * <p>
 * Created by zzy on 2017/2/9.
 */
public enum RedisKeyFactory {

    K001("用户信息"),
    K002("Abtest"),
    K003("活动弹层皮肤"),
    K004("活动皮肤"),
    K005("活动皮肤MD5"),
    K006("活动组"),
    K007("集卡助力规则"),
    K008("活动黑名单"),
    K009("用户账户信息缓存"),

    K010("外推活动链接映射"),
    K011("活动定向"),
    K012("助力之后奖励记录"),
    K013("规则集记录"),
    K014("规则记录列表"),
    K015("流量策略"),
    K016("活动参与次数"),
    K017("集卡数据"),
    K018("活动每日参与次数"),
    K019("活动每日免费次数"),

    K021("流量策略"),
    K022("流量策略2"),
    K023("活动黑名单列表缓存"),
    K024("活动定向缓存"),
    K025("开心码赛事配置信息id"),
    K026("开心码奖项配置信息id"),
    K027("开心码奖项配置信息上的期次id"),
    K028("开心码期次配置信息id"),

    K030("永久助力次数"),
    K031("永久邀请次数"),
    K032("邀请次数配置"),
    K033("每日助力次数"),
    K034("每日邀请次数"),
    K035("活动组次数"),
    K036("活动组id"),
    K037("账户每日收益统计"),

    K060("红包个数缓存"),
    K061("余额缓存"),
    K062("红包记录列表缓存"),
    K063("获得某日账户余额"),

    K070("用户加经验缓存"),
    K071("排行榜缓存"),
    K072("提现记录-小广播"),
    K073("提现记录"),
    K074("钱包过期处理时间"),
    K075("插件抽奖限制次数"),
    K076("兑吧活动每日参与次数"),

    K080("当月提现次数"),
    K081("通过appId 缓存全局钱包信息"),
    K082("全局钱包已提现金额记录"),
    K083("总账户周期创建"),
    K084("总账户查询"),

    K090("活动工具入库活动列表"),
    ;

    private String description;

    private RedisKeyFactory(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    /**
     * activity-comm-center
     */
    private static final String SPACE = "ACTCOMMC";

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }


}
