package cn.com.duiba.activity.common.center.api.remoteservice.consumeraccount;

import cn.com.duiba.activity.common.center.api.dto.consumeraccount.AppConsumerCashDrawsRecordResultDto;
import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerCashDrawsRecordDto;
import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountTypeEnum;
import cn.com.duiba.activity.common.center.api.params.AppConsumerCashDrawsRecordParam;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccountCashDrawsQueryRequest;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccountCashDrawsRequest;
import cn.com.duiba.activity.common.center.api.rsp.consumeraccounts.AccountCashDrawsResponse;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;

/**
 * 用户账户提现活动
 * Created by hww on 2018/3/23 下午2:57.
 */
@AdvancedFeignClient
public interface RemoteCashDrawService {

    /**
     * 账户不再直接提供对外的提现服务，提现由业务自己对提现做包装
     * 用户账户提现接口
     * @param request 账户提现接口入参列表 {@link AccountCashDrawsRequest}
     * @return
     */
    @Deprecated
    AccountCashDrawsResponse cashDraws(AccountCashDrawsRequest request);

    /**
     * 分页查询提现记录
     * 按照时间倒叙排列
     * @return
     */
    PageInfo<ConsumerCashDrawsRecordDto> findCashDrawsRecordList(AccountCashDrawsQueryRequest params) throws BizException;

    /**
     * 分页查询某个app一段时间的提现记录
     * 按照创建时间倒叙排列
     * @param param
     * @return
     */
    AppConsumerCashDrawsRecordResultDto findAppCashDrawsRecordList(AppConsumerCashDrawsRecordParam param);

    /**
     * 根据id 查询提现记录
     * @return
     */
    ConsumerCashDrawsRecordDto findById(Long id) throws BizException;

    /**
     * appId
     * accountType
     * @return
     */
    List<ConsumerCashDrawsRecordDto> findRolling(Long appId,Integer accountType) throws BizException;

    /**
     * 查询某个用户在date时间点之后是否有提现记录 (无论是否成功)
     */
    boolean hasCashDrawsRecord(Long consumerId, AccountTypeEnum accountTypeEnum, Date date);

    /**
     * 查询用户在一段时间之内的提现记录次数（排除失败的）
     * @param consumerId
     * @param accountTypeEnum
     * @param start
     * @param end
     * @return
     */
    Integer getRangeDateCashDrawsRecordCountExcludeFail(Long consumerId, AccountTypeEnum accountTypeEnum, Date start, Date end);

    /**
     * 查询用户在一段时间之内提现成功金额数
     * @param consumerId
     * @param accountTypeEnum
     * @param start
     * @param end
     * @return
     */
    Long getRangeDateCashDrawsSuccessAmount(Long consumerId, AccountTypeEnum accountTypeEnum, Date start, Date end);

    /**
     * 查询当月app下的提现次数
     */
    Integer getDrawCashCount(Long appId);

}