package cn.com.duiba.activity.common.center.api.remoteservice.direct;

import cn.com.duiba.activity.common.center.api.dto.direct.DuibaActivityAppSpecifyNewDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by suyuanlong on 16/7/19.
 */
@AdvancedFeignClient
public interface RemoteDuibaActivityAppSpecifyNewService {


    /**
     * 此方法在WEB端存在大量的循环调用(请相关部门优化)
     * 已经提供service层的优化方法:DuibaActivityAppSpecifyNewService.batchFindIsSpecifyActivityIds
     * @param activityId
     * @param appId
     * @param activityType
     * @return
     */
    DuibaActivityAppSpecifyNewDto findAppSpecifyByActivityIdAndAppIdAndActivityType(Long activityId, Long appId, String activityType);

    /**
     * @param activityId
     * @param type
     * @return
     */

    List<DuibaActivityAppSpecifyNewDto> findAppSpecifyByActivityIdAndActivityType(Long activityId, String type);

    /**
     * @param specifyBto
     * @return id
     */

    Long insertAppSpecify(DuibaActivityAppSpecifyNewDto specifyBto);

    /**
     * @param id
     * @return 0 1
     */
    Boolean deleteAppSpecifyById(Long id);

    /***
     * @param id
     * @return
     */
    DuibaActivityAppSpecifyNewDto findAppSpecifyById(Long id);

    /**
     * @param activityId
     * @param appId
     * @param activityType
     * @return
     */
    Boolean isNotAppSpecifyByActivityIdAndAppIdAndActivityType(Long activityId, Long appId, String activityType);
    /**
     * @param paras
     * @return 获取不是定向活动列表
     * @author zhujianda
     * 批量获取,减少dubbo交互
     */
    List<Long> notInappSpecifyActivitys(List<DuibaActivityAppSpecifyNewDto> paras);
    
    /**
     * notInappSpecifyActivitys. <br/>
     * 方法同上，参数不同
     * @author wubo
     * @param activityIds
     * @param appId
     * @param activityType
     * @return List<Long> 不是定向活动的ids
     * @since JDK 1.6
     */
    List<Long> notInappSpecifyActivitysNew(List<Long> activityIds, Long appId, String activityType);

    /**
     * inappSpecifyActivitys. <br/>
     * 方法同上，逻辑相反
     * @author wubo
     * @param activityIds
     * @param appId
     * @param activityType
     * @return List<Long> 是定向活动的ids
     * @since JDK 1.6
     */
    List<Long> inappSpecifyActivitys(List<Long> activityIds, Long appId, String activityType);

    /**
     * 根据活动id和活动类型批量查询被定向的appId
     * 最多支持查询100个activityId对应的定向信息
     * 若入参超出限制或入参为空，接口返回 null
     * @param activityIds
     * @param activityType
     * @return
     */
    List<Long> findAllAppIdByActivityIdsAndRelationType(List<Long> activityIds, String activityType);

    /**
     * 根据appId和活动类型查询定向活动的ID
     * @param appId
     * @param activityType
     * @return
     */
    List<Long> findByAppIdAndType(Long appId, String activityType);
}
