package cn.com.duiba.activity.common.center.api.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by sty on 2018/4/24.
 */
public enum WechatAccountInfo {
    /**
     * 运营直升机订阅号appId
     */
    WX_YUNYINGZSJ("wx0f69ba355f7210fd", "43fab83fb556333afd1691866bf67b96"),

    /**
     * 兑吧family订阅号
     */
    WX_DUIBAFAMILY("wxd15aebb2cb3320a9", "d1fc7059fbd238407bff5f213d9cd075");


    /**
     * 微信appId
     */
    private String wxAppId;

    /**
     * 【机密】密钥
     */
    private String wxAppSecrect;

    private static final Map<String, WechatAccountInfo> ENUM_MAP = new HashMap<>();

    static{
        for(WechatAccountInfo tmp : values()){
            ENUM_MAP.put(tmp.getWxAppId(), tmp);
        }
    }

    public static WechatAccountInfo getByWxAppId(String wxAppId) {
        return ENUM_MAP.get(wxAppId);
    }

    WechatAccountInfo(String wxAppId, String wxAppSecrect) {

        this.wxAppId = wxAppId;
        this.wxAppSecrect = wxAppSecrect;
    }

    public String getWxAppId() {
        return wxAppId;
    }

    public String getWxAppSecrect() {
        return wxAppSecrect;
    }
}
