package cn.com.duiba.activity.common.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 活动用户状态枚举
 * author zhanghuifeng
 * date 2019-03-20-18:18
 */
public enum ActUserStateEnum {

    MARKED(1, "打标状态"),
    NO_MARK(0, "取标状态"),
    ;

    private static Map<Integer, ActUserStateEnum> codeMap = new HashMap<>();
    static {
        for(ActUserStateEnum type : values()){
            codeMap.put(type.getCode(), type);
        }
    }

    public static ActUserStateEnum getByCode(Integer code){
        return codeMap.get(code);
    }

    private Integer code;
    private String desc;

    ActUserStateEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
