package cn.com.duiba.activity.common.center.api.remoteservice.share;

import cn.com.duiba.activity.common.center.api.dto.share.ShareHelpRecordDto;
import cn.com.duiba.activity.common.center.api.enums.share.ShareRelTypeEnum;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xiaoxuda
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteSharehelpRecordService {
	/**
	 * 新增数据
	 * @return 数据ID
	 */
	Long insert(ShareHelpRecordDto dto) throws BizException;


	/**
	 * 查询指定用户助力记录
	 * @return ShareHelpRecordDto
	 */
	ShareHelpRecordDto selectByRelIdAndConsumerIdAndHelpConsumerId(Long relId,Long consumerId,Long helpConsumerId,ShareRelTypeEnum relType)  throws BizException;


	/**
	 * 查询用户助力记录
	 * @return ShareHelpRecordDto
	 */
	List<ShareHelpRecordDto> selectByRelIdAndConsumerId(Long relId, Long consumerId,ShareRelTypeEnum relType)  throws BizException;


}