package cn.com.duiba.activity.common.center.api.remoteservice.black;

import cn.com.duiba.activity.common.center.api.dto.black.DeveloperBlackDto;
import cn.com.duiba.activity.common.center.api.params.black.BlackParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * ClassName:RemoteDeveloperBlackBackendService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 开发者黑名单列表  管理员端使用
 * @date 创建时间：2018/3/28  15:38
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteDeveloperBlackBackendService {

    /**
     *
     * findByDeveloperId 查询黑名单
     * @return
     * @since JDK 1.8
     */
    DeveloperBlackDto findByDeveloperId(Long developerId);

    /**
     *
     * 查询所有黑名单
     * @return
     * @since JDK 1.8
     */
    List<DeveloperBlackDto> findAll();

    /**
     * 获取 所有黑名单列表
     *
     * @param param
     *
     * @return PageInfo<DeveloperBlackDto>
     */
    PageInfo<DeveloperBlackDto> findPage(BlackParam param);

    /**
     * 把开发者添加到黑名单中
     * @param list
     */
     Integer addDevIntoBlacklist(List<DeveloperBlackDto> list);

    /**
     * 删除黑名单
     */
    Integer delete(Long id);
}