package cn.com.duiba.activity.common.center.api.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2019/4/30 15:03
 */
public enum WxJsTicketHostEnum {
    /**
     * js接口 安全域名
     */
    ACTIVITY("activity.m.duiba.com.cn", WechatAccountInfo.WX_YUNYINGZSJ),
    ACTIVITY_1("activity-1.m.duiba.com.cn", WechatAccountInfo.WX_YUNYINGZSJ),
    ACTIVITY_2("activity-2.m.duiba.com.cn", WechatAccountInfo.WX_YUNYINGZSJ),

    DUIBA_MOBILE("m.duiba.com.cn", WechatAccountInfo.WX_QIHO),
    DUIBA_MOBILE_PRE("m.duibapre.com.cn", WechatAccountInfo.WX_QIHO),

    ACTIVITY_3("activity-3.m.duiba.com.cn", WechatAccountInfo.WX_DUIBAFAMILY),
    ACTIVITY_5("activity-5.m.duiba.com.cn", WechatAccountInfo.WX_DUIBAFAMILY),
    ;

    private String domain;

    private WechatAccountInfo wxAppInfo;

    WxJsTicketHostEnum(String domain, WechatAccountInfo wxAppInfo) {
        this.domain = domain;
        this.wxAppInfo = wxAppInfo;
    }

    private static final Map<String, WxJsTicketHostEnum> ENUM_MAP = new HashMap<>();

    static{
        for(WxJsTicketHostEnum tmp : values()){
            ENUM_MAP.put(tmp.getDomain(), tmp);
        }
    }

    public static WxJsTicketHostEnum getByCode(String domain) {
        return ENUM_MAP.get(domain);
    }

    public String getDomain() {
        return domain;
    }

    public WechatAccountInfo getWxAppInfo() {
        return wxAppInfo;
    }
}
