package cn.com.duiba.activity.custom.center.api.remoteservice;

import cn.com.duiba.activity.custom.center.api.dto.becheery.BecheeryCakeDto;
import cn.com.duiba.activity.custom.center.api.dto.becheery.BecheeryScanLogDto;
import cn.com.duiba.activity.custom.center.api.dto.becheery.BecheeryShopDto;
import cn.com.duiba.activity.custom.center.api.dto.becheery.BecheeryVisitorDto;
import cn.com.duiba.activity.custom.center.api.dto.becheery.GetVisitorDto;
import cn.com.duiba.activity.custom.center.api.dto.becheery.PopularitysRanksDto;
import cn.com.duiba.activity.custom.center.api.dto.becheery.UpdateShopPopularityDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Auther: linjianhui
 * @Date: 2018/8/28 10:23
 * @Description: 百草味中秋活动服务
 */
@AdvancedFeignClient
public interface RemoteBecheeryService {
    /**
     * 根据用户查询店铺信息
     * @param consumerId
     * @return
     */
    BecheeryShopDto findBecheeryShopByConsumerId(Long consumerId);

    /**
     * 插入店铺记录，返回时，生成的id会设置进去
     * @param shopDto
     * @return
     */
    BecheeryShopDto insertBecheeryShop(BecheeryShopDto shopDto);

    /**
     * 修改店铺相关信息
     * @param shopDto
     * @return
     */
    Boolean updateBecheeryShop(BecheeryShopDto shopDto);

    /**
     * 插入月饼记录，返回时，生成的id会设置进去
     * @param cakeDto
     * @return
     */
    BecheeryCakeDto insertBecheeryCake(BecheeryCakeDto cakeDto);

    /**
     * 通过id查询月饼
     * @param id
     * @return
     */
    BecheeryCakeDto findBecheeryCakeById(Long id);

    /**
     * 通过用户ID，月饼ID 查询月饼扫描记录
     * @param consumerId
     * @param cakeId
     * @return
     */
    BecheeryScanLogDto findBecheeryScanLog(Long consumerId, Long cakeId);

    /**
     * 插入月饼扫描记录
     * @param scanLogDto
     * @return
     */
    BecheeryScanLogDto insertBecheeryScanLog(BecheeryScanLogDto scanLogDto);

    /**
     * 修改月饼扫描记录相关信息（中奖状态）
     * @param scanLogDto
     * @return
     */
    Boolean updateBecheeryScanLog(BecheeryScanLogDto scanLogDto);

    /**
     * 根据用户ID查询中奖次数
     * @param consumerId
     * @return
     */
    int findPrizeTimesByConsumerId(Long consumerId);

    /**
     * 根据用户ID，访客ID查询访客记录
     * @param consumerId
     * @param visitorConsumerId
     * @return
     */
    BecheeryVisitorDto findBecheeryVisitorByConsumerIdVisitorId(Long consumerId, Long visitorConsumerId);

    /**
     * 增加访客记录（当前只需consumerId, visitorConsumerId字段）
     * @param becheeryVisitorDto
     * @return
     */
    BecheeryVisitorDto insertBecheeryVisitor(BecheeryVisitorDto becheeryVisitorDto);

    /**
     * 通过主键ID更新访客记录（除了id需要设置，其他需要修改的字段才设置，如：cakeHelpStatus，gmtCakeHelp，gmtLast）
     * @param becheeryVisitorDto
     * @return
     */
    Boolean updateBecheeryVisitor(BecheeryVisitorDto becheeryVisitorDto);

    /**
     * 通过用户ID更新，更新字段同上
     * @param becheeryVisitorDto
     * @return
     */
    Boolean updateVisitorByConsumerId(BecheeryVisitorDto becheeryVisitorDto);

    /**
     * 获取店铺人气排名榜单
     * @return
     */
    List<PopularitysRanksDto> getPopularitysShop();

    /**
     * 获取用户店铺人气排名
     * @param consumerId
     * @return
    */
    PopularitysRanksDto getSelfRanks(Long consumerId);

    /**
     * 获取访客列表
     * @return
     */
    List<BecheeryVisitorDto> getVisitorList(GetVisitorDto getVisitorDto);

    /**
     * 批量更改店铺人气值
     * @param updateShopPopularityList
     * @return
     */
    Boolean updateShopPopularity(List<UpdateShopPopularityDto> updateShopPopularityList);

    /**
     * 批量更改店铺开奖状态
     * @param consumerIds
     * @return
     */
    Boolean updateTopJoinStatus(List<Long> consumerIds);

    /**
     * 通过用户id获取助力成功的访客的信息
     * @param consumerId
     * @return
     */
    List<BecheeryVisitorDto> findHelpSuccVisitorByConsumerId(Long consumerId);

}
