package cn.com.duiba.activity.custom.center.api.remoteservice.shuqi;

import cn.com.duiba.activity.custom.center.api.dto.shuqi.ShuqiPetConsumerLevelInfoDto;
import cn.com.duiba.activity.custom.center.api.dto.shuqi.ShuqiPetConsumerPetDto;
import cn.com.duiba.activity.custom.center.api.dto.shuqi.ShuqiPetNewRewardInfoDto;
import cn.com.duiba.activity.custom.center.api.params.ActivityBaseParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 书旗叠小七活动远程服务
 * Created by HePeng on 2019/08/15 14:20.
 */
@AdvancedFeignClient
public interface RemoteShuqiPetService {
    /**
     * 批量新增萌宠
     * @param dtoList
     * @throws BizException
     */
    void batchAdd(List<ShuqiPetConsumerPetDto> dtoList) throws BizException;

    /**
     * 获取用户最高萌宠等级 和 对应数量
     * @param param
     * @return
     */
    ShuqiPetConsumerLevelInfoDto getConsumerMaxLevelInfo(ActivityBaseParam param);

    /**
     * 获取用户游戏区萌宠列表
     * @param param
     * @return
     */
    List<ShuqiPetConsumerPetDto> getConsumerGameZonePetList(ActivityBaseParam param);

    /**
     * 获取用户召唤区萌宠信息列表
     * @param param
     * @return
     */
    List<ShuqiPetConsumerLevelInfoDto> getConsumerCallZoneLevelInfoList(ActivityBaseParam param);

    /**
     * 获取用户新赠送的萌宠信息（阅读、邀请），返回前就更新弹窗状态
     * @param param
     * @return
     */
    ShuqiPetNewRewardInfoDto getConsumerNewRewardInfo(ActivityBaseParam param);

    /**
     * 召唤萌宠
     * @param param
     * @param level
     * @param holeIndex
     * @return
     * @throws BizException
     */
    boolean callPet(ActivityBaseParam param, Integer level, Integer holeIndex) throws BizException;

    /**
     * 挪动萌宠位置
     * @param param
     * @param id
     * @param holeIndex
     * @return
     * @throws BizException
     */
    boolean movePet(ActivityBaseParam param, Long id, Integer holeIndex) throws BizException;

    /**
     * 回收萌宠
     * @param param
     * @param id
     * @return
     * @throws BizException
     */
    boolean recoverPet(ActivityBaseParam param, Long id) throws BizException;

    /**
     * 合并萌宠
     * @param param
     * @param fromId
     * @param toId
     * @return
     * @throws BizException
     */
    ShuqiPetConsumerPetDto mergePet(ActivityBaseParam param, Long fromId, Long toId) throws BizException;

    /**
     * 获取用户萌宠统计信息列表
     * @param param
     * @return
     */
    List<ShuqiPetConsumerLevelInfoDto> getConsumerAllLevelInfoList(ActivityBaseParam param);

}
