package cn.com.duiba.activity.custom.center.api.dto.ningbo;

import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br>
 * 〈〉
 *
 * @author xcw
 * @create 2020/8/20
 * @since 1.0.0
 */
public class DeductCreditsDto implements Serializable{
    private static final long serialVersionUID = 6815015289397024655L;

    /**
     * 用户id
     */
    private String uid;

    /**
     * 要扣除或者增加的金币
     */
    private String credits;

    /**
     * 宁波订单号
     */
    private String ordernum;

    /**
     * 积分处理类型
     */
    private CreditsDeductType creditsDeductType;

    /**
     * 备注信息，加减金币的描述信息
     */
    private String attach;

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getCredits() {
        return credits;
    }

    public void setCredits(String credits) {
        this.credits = credits;
    }

    public String getOrdernum() {
        return ordernum;
    }

    public void setOrdernum(String ordernum) {
        this.ordernum = ordernum;
    }

    public CreditsDeductType getCreditsDeductType() {
        return creditsDeductType;
    }

    public void setCreditsDeductType(CreditsDeductType creditsDeductType) {
        this.creditsDeductType = creditsDeductType;
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public static enum CreditsDeductType{
        /**
         * 加积分
         */
        ADD("1"),
        /**
         * 减积分
         */
        DEDUCT("0");

        private String type;

        CreditsDeductType(String type){
            this.type = type;
        }

        public String getType() {
            return type;
        }

        private static final Map<String,CreditsDeductType> map = Maps.newHashMap();

        static {
            for(CreditsDeductType creditsChangeType : values()){
                map.put(creditsChangeType.getType(), creditsChangeType);
            }
        }

        public static CreditsDeductType mapOf(String type){
            return map.get(type);
        }
    }
}