package cn.com.duiba.activity.custom.center.api.remoteservice.tasklog;

import cn.com.duiba.activity.custom.center.api.dto.tasklog.ZzhArticleLogDto;
import cn.com.duiba.activity.custom.center.api.params.tasklog.ReadArticleParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author haojiahong
 * @date 2021-04-07
 */
@AdvancedFeignClient
public interface RemoteZzhArticleLogService {

    /**
     * 获取用户已阅读的文章集合（最多100篇）
     *
     * @param appId
     * @param consumerId
     * @param actionType
     * @param articleIdList
     * @return
     * @throws BizException
     */
    List<ZzhArticleLogDto> getDoneArticleList(Long appId, Long consumerId, Integer actionType, List<String> articleIdList) throws BizException;

    /**
     * 完成文章任务
     *
     * @param articleParam
     * @return
     */
    Long doActionArticle(ReadArticleParam articleParam);


    /**
     * 查询用户某一篇文章的阅读记录
     *
     * @param appId
     * @param consumerId
     * @param actionType
     * @param articleId
     * @return
     */
    ZzhArticleLogDto getLogByArticleId(Long appId, Long consumerId, Integer actionType, String articleId);

    /**
     * 获取已经获得的积分总和
     *
     * @param appId
     * @param consumerId
     * @return
     */
    Integer getGainCredits(Long appId, Long consumerId);
}
