package cn.com.duiba.activity.custom.center.api.remoteservice.customCity;

import cn.com.duiba.activity.custom.center.api.dto.customcity.CustomCityDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @description:
 * @author: lja
 * @date: Created on 2020/4/22 11:06
 * @version:
 */
@AdvancedFeignClient
public interface RemoteCustomCityService {

    /** 查询所有城市列表 */
    List<CustomCityDto> selectAll(Long appId);

    /**
     * 模糊搜索城市 可以是拼音或汉字
     * 例如：根据bei可以搜索到北京
     * 但是根据bj，bej等无法搜索到北京
     * */
    List<CustomCityDto> searchByCityName(Long appId,String city);

    /** 根据城市id 精确查找城市信息 */
    CustomCityDto searchByCityId(Long appId,String cityId);

    /** 根据城市名称 精确查找城市信息 */
    CustomCityDto findByCityName(Long appId, String city);

    /** 同步CGV影城城市信息 */
    void syncAllCityFromCGV();
}
