package cn.com.duiba.activity.custom.center.api.remoteservice.pinganshengqian;

import cn.com.duiba.activity.custom.center.api.dto.pinganshengqian.PingAnShengQianActRecordDto;
import cn.com.duiba.activity.custom.center.api.params.pinganshengqian.PingAnShengQianRecordParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @descriptions: 平安省钱小程序 激活记录remote
 * @author: Wei Yi Ye
 * @date: 2024/11/20 18:14
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemotePingAnSqActRecordService {
    /**
     * 插入激活记录并更新激活码
     *
     * @param param 激活记录参数
     */
    Boolean insertRecordAndUpdateCode(PingAnShengQianRecordParam param) throws BizException;

    /**
     * 根据uid查询激活记录(未过期的)
     *
     * @param appId appId
     * @param uid   uid
     */
    PingAnShengQianActRecordDto queryActRecordByUid(Long appId, String uid);

    /**
     * 更新当前余额
     * @param id  id
     * @param currentLimit 更新后的余额
     */
    boolean updateCurrentLimit(Long id,Integer currentLimit);

}
