package cn.com.duiba.activity.custom.center.api.dto.pinganshengqian;

public enum PingAnOrderStatusEnum {
    ORDER_GENERATED(0, "订单生成"),
    PAYMENT_RECEIVED_SUCCESS(1, "收单成功"),
    PAYMENT_RECEIVED_FAILED(2, "收单失败"),
    PAYMENT_FAILED(3, "支付失败"),
    PAYMENT_SUCCESS(4, "支付成功"),
    PAYMENT_CANCELLED(5, "取消支付"),
    REFUND_IN_PROGRESS(6, "退款中"),
    REFUND_SUCCESS(7, "退款成功"),
    REFUND_FAILED(8, "退款失败"),
    ORDER_CANCEL(9, "订单取消");

    // 状态码
    private final int code;
    // 状态描述
    private final String description;

    // 构造函数
    PingAnOrderStatusEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    // 获取状态码
    public int getCode() {
        return code;
    }

    // 获取状态描述
    public String getDescription() {
        return description;
    }

    // 根据状态码获取枚举实例
    public static PingAnOrderStatusEnum fromCode(int code) {
        for (PingAnOrderStatusEnum status : PingAnOrderStatusEnum.values()) {
            if (status.code == code) {
                return status;
            }
        }
        throw new IllegalArgumentException("未知的状态码: " + code);
    }

    @Override
    public String toString() {
        return "OrderStatus{" +
                "code=" + code +
                ", description='" + description + '\'' +
                '}';
    }
}
