package cn.com.duiba.activity.custom.center.api.enums.ccb;

import java.util.HashMap;
import java.util.Map;

/**
 * 虚拟订单状态
 */
public enum SupplierOrderStatusEnum {


    INIT(1, "订单初始化"),
    SEND_OK(2,"通知供应商成功"),
    WAIT_NOTIFY(3,"等待供应商通知"),
    SEND_FAIL(4,"通知供应商失败"),

    ORDER_SUCCESS(5,"订单兑换完成"),
    ORDER_FAIL(6,"订单兑换失败");
    ;

    private Integer code;

    private String desc;

    private static final Map<Integer, SupplierOrderStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(SupplierOrderStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    SupplierOrderStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static SupplierOrderStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
