package cn.com.duiba.anticheat.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * @author JunAngLiu
 * @Title: RiskRouteDto
 * @Description: 风控路由dto
 * @date 2019/9/714:23
 */
public class RiskRouteDto implements Serializable {

    private static final long serialVersionUID = -319622618872976489L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 0 其它,1 星速台活动,2 普通活动
     */
    private Integer bizType;

    /**
     * 风控标签：60000自定义,60001 拉新,60002 促活,60003 留存,60004 积分消耗,60005 游戏,60006 秒杀
     */
    private Integer projectLabel;

    /**
     * 非星速台活动的活动类型
     */
    private Integer activityType;

    /**
     * 项目id:风控标签为 自定义时填写
     */
    private String projectId;

    /**
     * 兑吧应用id
     */
    private Long appId;

    /**
     * 风控主场景: 1 提现,2 参与,3 发奖
     */
    private Integer scene;

    /**
     * 场景标识
     */
    private String sceneIdentity;

    /**
     * 惩罚方式:1 拒绝流程,文案提示
     */
    private Integer punishWay;

    /**
     * 文案
     */
    private String copy;

    /**
     * 修改人
     */
    private String modifier;

    /**
     * 0 未删除, 1 已删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public Integer getProjectLabel() {
        return projectLabel;
    }

    public void setProjectLabel(Integer projectLabel) {
        this.projectLabel = projectLabel;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public String getSceneIdentity() {
        return sceneIdentity;
    }

    public void setSceneIdentity(String sceneIdentity) {
        this.sceneIdentity = sceneIdentity;
    }

    public Integer getPunishWay() {
        return punishWay;
    }

    public void setPunishWay(Integer punishWay) {
        this.punishWay = punishWay;
    }

    public String getCopy() {
        return copy;
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }

    public String getModifier() {
        return modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
