package cn.com.duiba.anticheat.center.api.param;

import java.io.Serializable;

/**
 * @author XuJing
 * @since 2020/4/3 10:05 上午
 */
public class ActivityBlackListParam implements Serializable {

    private static final long serialVersionUID = 8313470547580552346L;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 兑吧用户id
     */
    private Long customerId;

    /**
     * ip 模糊
     */
    private String ip;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 偏移量
     */
    private Integer offset;

    /**
     * 页码
     */
    private Integer pageNo;

    /**
     * 每页大小
     */
    private Integer pageSize;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Integer getOffset() {
        if (null != pageNo && null != pageSize) {
            return (this.pageNo - 1) * this.pageSize;
        }
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
