package cn.com.duiba.apollo.center.api.utils;

import com.google.common.collect.Sets;
import org.apache.commons.lang.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RenderUtils {

    public static final Pattern RENDER_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");

    public static Set<String> analysisTemplateDependenceKey(List<String> texts){
        Set<String> keys = Sets.newHashSet();
        for(String text:texts){
            keys.addAll(analysisTemplateDependenceKey(text));
        }
        return keys;
    }

    public static Set<String> analysisTemplateDependenceKey(String text){
        if(StringUtils.isBlank(text)){
            return Collections.emptySet();
        }
        Set<String> keys = Sets.newHashSet();
        Matcher matcher = RENDER_PATTERN.matcher(text);
        while(matcher.find()){
            // 键名
            String name = matcher.group(1);
            keys.add(name);
        }
        return keys;
    }

}
