/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.apollo.center.api.remoteservice;

import cn.com.duiba.apollo.center.api.domain.dto.AbstractResourceInstanceOwnerDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 描述: 抽象资源实例Owner
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/6/25 11:37
 */
@AdvancedFeignClient
public interface RemoteAbstractResourceInstanceOwnerService {

    boolean saveOwner(String type, String instanceKey, List<Long> ownerIdList);

    List<AbstractResourceInstanceOwnerDto> getOwner(String type, String instanceKey);

}
