define([
    "angular",
    "/apollo/textareafullscreen/jquery.textareafullscreen.js",
    "css!/apollo/textareafullscreen/textareafullscreen.css",
], function (angular) {

    const apollo = angular.module("apollo.ui.common",[]);

    const hidden = new RegExp('[\\s|\\n|\\t]','g');//隐藏字符
    const reg = new RegExp('[\u4e00-\u9fa5]+', 'g');//中文
    const punctuators = new RegExp('[\u3002|\uff1f|\uff01|\uff0c|\u3001|\uff1b|\uff1a|\u201c|\u201d|\u2018|\u2019|\uff08|\uff09|\u300a|\u300b|\u3008|\u3009|\u3010|\u3011|\u300e|\u300f|\u300c|\u300d|\ufe43|\ufe44|\u3014|\u3015|\u2026|\u2014|\uff5e|\ufe4f|\uffe5]','g');//标点符号

    const charMap = new Map();
    charMap.set("\t",'#制表符#');
    charMap.set("\n",'#换行符#');
    charMap.set(' ','#空格#');

    apollo.config(function () {
        Date.prototype.Format = function (fmt) {
            var o = {
                "M+": this.getMonth() + 1, //月份
                "d+": this.getDate(), //日
                "h+": this.getHours(), //小时
                "m+": this.getMinutes(), //分
                "s+": this.getSeconds(), //秒
                "q+": Math.floor((this.getMonth() + 3) / 3), //季度
                "S": this.getMilliseconds() //毫秒
            };
            if (/(y+)/.test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
            }
            for (var k in o) {
                if (new RegExp("(" + k + ")").test(fmt)) {
                    fmt =
                        fmt.replace(RegExp.$1,
                            (RegExp.$1.length === 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
                }
            }
            return fmt;
        };
    });

    apollo.value("checkHiddenChar",checkHiddenChar);
    apollo.value("checkChinese",checkChinese);
    apollo.value("swapHiddenChar",swapHiddenChar);
    apollo.directive('textareaFullScreen', Textareafullscreen);

    apollo.controller('PreViewItemsController', PreViewItemsController);
    apollo.controller('ShowTextModalController', ShowTextModalController);
    apollo.controller('ItemKeyValueModelController', ItemKeyValueModelController);

    apollo.filter("pswView",PswViewFilter);

    function PswViewFilter(){

        return function(value){
            const count = String(value).length;
            var result = "";
            for(let i=0;i<count;i++){
                result += "*";
            }
            return result;
        }

    }

    function Textareafullscreen(){
        return {
            restrict: 'A',
            link:function($scope, $element, attrs){
                $element.textareafullscreen();
            }
        }
    }

    function checkHiddenChar(text){
        var list = text.match(hidden);
        if(!list){
            list = [];
        }
        return new Set(list);
    }

    function checkChinese(text){
        var list = text.match(reg);
        if(!list){
            list = [];
        }
        var pList = text.match(punctuators);
        if(!pList){
            pList = [];
        }
        list = list.concat(pList);
        return new Set(list);
    }

    function swapHiddenChar(text){
        var valueWithHiddenChars = text;
        for (let i = 0; i < text.length; i++) {
            var c = text[i];
            if (charMap.has(c)) {
                valueWithHiddenChars = valueWithHiddenChars.replace(c, "<mark>"+charMap.get(c)+"</mark>");
            }
        }
        return valueWithHiddenChars;
    }

    function PreViewItemsController($http,$scope,$uibModalInstance,items,UiModel,checkHiddenChar,checkChinese){

        $scope.items = [];
        $scope.oprTypeMap = {"create":"新增","update":"更新","delete":"删除"};

        cherkItems(items);

        function cherkItems(items){
            $scope.items = [];
            items.each(function(item){
                if(!item.key){
                    return;
                }
                var chars = [];
                if(!item.newValue){
                    item.pass = true;
                    item.chars = chars;
                }else{
                    var set = checkHiddenChar(item.newValue);
                    set.forEach(function(it){
                        chars.push(charMap.get(it));
                    });
                    var cnChar = checkChinese(item.newValue);
                    cnChar.forEach(function(it){
                        chars.push(it);
                    });
                    item.pass = !chars.length;
                    item.chars = chars;
                }
                $scope.items.push(item);
            });
            if(!$scope.items.length){
                UiModel.message("没有任何变更","warning");
            }
        }

        $scope.cancel = function () {
            $uibModalInstance.dismiss();
        };

        $scope.submit = function () {
            var noPassIndex = -1;
            $scope.items.each(function(item,index){
                if(!item.pass){
                    noPassIndex = index;
                }
            });
            if(noPassIndex>=0){
                UiModel.message("第"+(noPassIndex+1)+"个配置项未处理，无法提交","warning");
                return;
            }
            $uibModalInstance.close();
        };

    }

    function ShowTextModalController($scope,text,$uibModalInstance){
        $scope.text = text;
        $scope.$watch('text', init);

        $scope.cancel = function () {
            $uibModalInstance.dismiss();
        };

        function init() {
            $scope.jsonObject = undefined;
            if (isJsonText($scope.text)) {
                $scope.jsonObject = JSON.parse(text);
            }
        }

        function isJsonText(text) {
            try {
                return typeof JSON.parse(text) === "object";
            } catch (e) {
                return false;
            }
        }
    }

    function ItemKeyValueModelController($uibModalInstance,UiModel,$scope,$sce,item,toastr){

        $scope.item = item;
        $scope.showHiddenCharsContext = false;
        $scope.hiddenCharCounter = 0;
        $scope.valueWithHiddenChars = $sce.trustAsHtml('');
        $scope.cnChars = [];
        var clusters = [];

        $scope.encrypt = encrypt;
        $scope.charkPassword = charkPassword;
        $scope.showHiddenChars = showHiddenChars;
        $scope.submit = submit;

        $scope.flushClusters = function(reuslt){
            clusters = reuslt;
        };

        function submit(){

            if (!$scope.item.value) {
                $scope.item.value = "";
            }
            if (!$scope.item.comment) {
                $scope.item.comment = "";
            }

            const set = checkHiddenChar($scope.item.value);
            if(set.size>0){
                UiModel.confirm("配置中存在隐藏字符，建议对value进行检测或者忽略提示继续提交。","提示",{
                    submitBtn:"继续提交",
                    size:"sm"
                }).then(doItem);
                return;
            }
            const cnChar = checkChinese($scope.item.value);
            if(cnChar.size>0){
                UiModel.confirm("配置中存在中文字符，建议对value进行检测或者忽略提示继续提交。","提示",{
                    submitBtn:"继续提交",
                    size:"sm"
                }).then(doItem);
                return;
            }
            doItem();
        }

        function encrypt(){
            if(!$scope.item.value){
                UiModel.message("空内容无需执行加密","info");
                return;
            }
            $scope.item.password = true;
            toastr.info("已经将配置设置成密文");
        }

        function charkPassword(){
            if(!$scope.item.password){
                return;
            }
            $scope.item.password = false;
            $scope.item.value = "";
        }

        function doItem() {
            const result = {
                key:$scope.item.key,
                value:$scope.item.value,
                password:$scope.item.password,
                comment:$scope.item.comment
            };

            if(!result.key){
                toastr.error("Key不能为空");
                return;
            }
            if($scope.item.needSelectCluster){
                if (clusters.length === 0) {
                    toastr.error("请至少选一个集群");
                    return;
                }
                result.clusters = clusters;
            }
            $uibModalInstance.close(result)
        }

        function showHiddenChars() {
            var value = $scope.item.value;
            if (!value) {
                return;
            }
            const set = checkHiddenChar(value);
            const cnChar = checkChinese(value);

            var hiddenCharCounter = set.size;
            var valueWithHiddenChars = swapHiddenChar(value,set);

            $scope.showHiddenCharsContext = true;
            $scope.hiddenCharCounter = hiddenCharCounter;
            $scope.valueWithHiddenChars = $sce.trustAsHtml(valueWithHiddenChars);
            const cnChars = [];
            cnChar.forEach(function(item){
                cnChars.push(item);
            });
            $scope.cnChars = cnChars;
        }

        $scope.cancel = function () {
            $uibModalInstance.dismiss();
        };
    }

    return apollo;
})