package cn.com.duiba.apollo.ui;

import cn.com.duiba.sso.ui.resource.SsoUIResManager;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 * @author liuyao
 */
public class ApolloWebMvcConfigurer implements WebMvcConfigurer {

    @Resource
    private SsoUIResManager ssoUiResManager;

    @PostConstruct
    public void init(){
        ssoUiResManager.regestModule("apollo.configuration","/apollo/apollo-configuration");
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/apollo/**")
                .addResourceLocations("classpath:/apollo/");
    }

}
