package cn.com.duiba.apollo.ui.controller;

import cn.com.duiba.apollo.client.dto.ResourceReferenceDTO;
import cn.com.duiba.apollo.client.params.StartReferenceParams;
import cn.com.duiba.apollo.client.remoteservice.RemoteResourceReferenceService;
import cn.com.duiba.apollo.client.service.ApolloAccessTokenService;
import cn.com.duiba.apollo.ui.ApolloResourceService;
import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.sso.api.service.logger.SsoLogger;
import cn.com.duiba.sso.api.service.logger.annotation.SsoLoggerMethod;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author liuyao
 */
@RestController
@RequestMapping("/${duiba.sso.root-path:'/apollo'}/resourceApi")
public class ApolloResourceController {

    @Resource
    private ApolloAccessTokenService apolloAccessTokenService;
    @Resource
    private ApolloResourceService apolloResourceService;
    @Resource
    private Environment currentEnvironment;
    @Resource
    private RemoteResourceReferenceService remoteResourceReferenceService;

    /**
     * 发起引用资源的请求
     */
    @PostMapping("/applyResourceInstance/{bizId}")
    public JsonRender applyResourceInstance(@PathVariable String bizId,@RequestBody ResourceReferenceDTO reference) throws BizException {

        Long adminId = RequestTool.getAdminId();
        reference.setOperator(adminId);
        reference.setBizId(bizId);
        apolloResourceService.buildApolloInstanceRelation(reference);
        JsonRender render = JsonRender.successResult();
        if(currentEnvironment==Environment.DEV){
            render.put("message","资源实例申请成功");
        }else{
            render.put("message","资源实例申请成功,等待审核");
        }
        return render;
    }

    @DeleteMapping("/removeResourceReference/{bizId}")
    public JsonRender removeResourceReference(@PathVariable String bizId,@RequestParam Long referenceId) throws BizException {
        String accessToken = apolloAccessTokenService.getAccessToken();
        ResourceReferenceDTO reference = remoteResourceReferenceService.findResourceReference(accessToken,referenceId);
        if(Objects.isNull(reference)){
            throw new BizException("关联不存在");
        }
        if(!StringUtils.equals(bizId,reference.getBizId())){
            throw new BizException("参数异常");
        }
        remoteResourceReferenceService.removeResourceReference(accessToken,RequestTool.getAdminId(),reference.getId());
        return JsonRender.successResult();
    }

    @SsoLoggerMethod(value = "应用:${bizId}启用资源${instanceId}",group = "资源启用")
    @PostMapping("/startReference/{bizId}")
    public JsonRender startReference(@PathVariable String bizId,@RequestBody StartReferenceParams params) throws BizException {
        String accessToken = apolloAccessTokenService.getAccessToken();
        ResourceReferenceDTO reference = remoteResourceReferenceService.findResourceReference(accessToken,params.getReferenceId());
        if(Objects.isNull(reference)){
            throw new BizException("关联不存在");
        }
        if(!StringUtils.equals(bizId,reference.getBizId())){
            throw new BizException("参数异常");
        }
        remoteResourceReferenceService.startReference(accessToken,reference.getId(),params);
        SsoLogger.logForPojo(reference);
        return JsonRender.successResult();
    }

    @SsoLoggerMethod(value = "应用:${bizId}停用资源${instanceId}",group = "资源停用")
    @DeleteMapping("/stopReference/{bizId}")
    public JsonRender stopReference(@PathVariable String bizId,@RequestParam Long referenceId) throws BizException {
        String accessToken = apolloAccessTokenService.getAccessToken();
        ResourceReferenceDTO reference = remoteResourceReferenceService.findResourceReference(accessToken,referenceId);
        if(!StringUtils.equals(bizId,reference.getBizId())){
            throw new BizException("参数异常");
        }
        remoteResourceReferenceService.stopReference(accessToken,referenceId);
        SsoLogger.logForPojo(reference);
        return JsonRender.successResult();
    }




}
