define([
    "angular"
], function (angular) {

    const apollo = angular.module("apollo.resource.service",[]);

    apollo.controller("TemplateSelectController",TemplateSelectController);
    apollo.service("ApolloResourceService",ApolloResourceService);
    apollo.service("ApolloTemplateService",ApolloTemplateService);

    function ApolloTemplateService($uibModal){

        function openTemplateSelectModal(resourceInstance){
            const instance = $uibModal.open({
                size: "lg",
                animation: true,
                templateUrl: '/apollo/model/template-select.html',
                controller: "TemplateSelectController",
                backdrop: 'static',
                resolve:{
                    resourceInstance:function(){
                        return resourceInstance;
                    }
                }
            });
            return instance.result;
        }

        return {
            openTemplateSelectModal
        }
    }

    function TemplateSelectController($uibModalInstance,$scope,resourceInstance,$http,ApolloService){

        $scope.templates = [];
        $scope.instance = resourceInstance;

        $http.get($rootPath+"/apolloApi/findAllTemplates",{params:{type:resourceInstance.type}}).success(function(templates){
            $scope.templates = templates;
        });

        $scope.select = function (template) {
            $uibModalInstance.close(template);
        };

        $scope.preview = function(template){
            ApolloService.preview(resourceInstance.id,template.id);
        };

        $scope.cancel = function () {
            $uibModalInstance.dismiss();
        };
    }


    function ApolloResourceService($resource, $q){
        const apolloResource = $resource('', {}, {
            applyResourceInstance: {
                method: 'POST',
                isArray: false,
                url: $rootPath+'/resourceApi/applyResourceInstance/:bizId'
            },
            removeResourceReference:{
                method: 'DELETE',
                isArray: false,
                url: $rootPath+'/resourceApi/removeResourceReference/:bizId?referenceId=:referenceId'
            },
            startReference:{
                method: 'POST',
                isArray: false,
                url: $rootPath+'/resourceApi/startReference/:bizId'
            },
            stopReference:{
                method: 'DELETE',
                isArray: false,
                url: $rootPath+'/resourceApi/stopReference/:bizId?referenceId=:referenceId'
            },
        });

        function applyResourceInstance(bizId, instanceId){
            const params = {instanceId};
            const defer = $q.defer();
            apolloResource.applyResourceInstance({bizId},params,function (result) {
                defer.resolve(result);
            }, function (result) {
                defer.reject(result);
            });
            return defer.promise;
        }

        function removeResourceReference(bizId, referenceId){
            const defer = $q.defer();
            apolloResource.removeResourceReference({bizId,referenceId},function (result) {
                defer.resolve(result);
            }, function (result) {
                defer.reject(result);
            });
            return defer.promise;
        }

        function startReference(bizId,params){
            const defer = $q.defer();
            apolloResource.startReference({bizId},params,function (result) {
                defer.resolve(result);
            }, function (result) {
                defer.reject(result);
            });
            return defer.promise;
        }

        function stopReference(bizId, referenceId){
            const defer = $q.defer();
            apolloResource.stopReference({bizId,referenceId},function (result) {
                defer.resolve(result);
            }, function (result) {
                defer.reject(result);
            });
            return defer.promise;
        }

        return {
            applyResourceInstance,
            removeResourceReference,
            startReference,
            stopReference
        }

    }

});