/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.ui.controller;

import cn.com.duiba.apollo.center.api.domain.dto.ResourceTemplateDto;
import cn.com.duiba.apollo.center.api.domain.dto.ResourceTypeDto;
import cn.com.duiba.apollo.center.api.domain.params.KeyValue;
import cn.com.duiba.apollo.center.api.remoteservice.RemoteApolloTemplateService;
import cn.com.duiba.apollo.center.api.remoteservice.RemoteResourceTypeService;
import cn.com.duiba.apollo.client.dto.PagenationDTO;
import cn.com.duiba.apollo.client.dto.ReferenceItemViewDTO;
import cn.com.duiba.apollo.client.dto.ResourceInstanceDTO;
import cn.com.duiba.apollo.client.dto.ResourceReferenceDTO;
import cn.com.duiba.apollo.client.params.InstanceConfigParams;
import cn.com.duiba.apollo.client.params.PublishReferenceParams;
import cn.com.duiba.apollo.client.params.ReferenceItemParams;
import cn.com.duiba.apollo.client.params.ResourceInstancePageParams;
import cn.com.duiba.apollo.client.remoteservice.RemoteResourceInstanceService;
import cn.com.duiba.apollo.client.remoteservice.RemoteResourceReferenceService;
import cn.com.duiba.apollo.client.service.ApolloAccessTokenService;
import cn.com.duiba.apollo.ui.ApolloResourceService;
import cn.com.duiba.apollo.ui.vo.ReferenceBO;
import cn.com.duiba.apollo.ui.vo.ResourceReferenceVO;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.sso.api.domain.dto.AdminInfoDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.service.logger.SsoLogger;
import cn.com.duiba.sso.api.service.logger.annotation.SsoLoggerMethod;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/${duiba.sso.root-path:'/apollo'}/apolloApi"})
public class ApolloInstanceConfigController {
    @Resource
    private RemoteResourceReferenceService remoteResourceReferenceService;
    @Resource
    private ApolloAccessTokenService apolloAccessTokenService;
    @Resource
    private ApolloResourceService apolloResourceService;
    @Resource
    private RemoteResourceInstanceService remoteResourceInstanceService;
    @Resource
    private RemoteAdminService remoteAdminService;
    @Resource
    private RemoteApolloTemplateService remoteApolloTemplateService;
    @Resource
    private RemoteResourceTypeService remoteResourceTypeService;

    @GetMapping(value={"/findApolloTypes"})
    public List<ResourceTypeDto> findApolloTypes() {
        return this.remoteResourceTypeService.findAllTypes();
    }

    @GetMapping(value={"/findAllTemplates"})
    public List<ResourceTemplateDto> findAllTemplates(@RequestParam String type) {
        return this.remoteApolloTemplateService.findResourceTemplateByType(type);
    }

    @PostMapping(value={"/findResourceInstancePage"})
    public PagenationDTO<ResourceInstanceDTO> findResourceInstancePage(@RequestBody @Valid ResourceInstancePageParams params) throws BizException {
        return this.remoteResourceInstanceService.findInstancePage(params);
    }

    @GetMapping(value={"/findAllReferenceByBizId"})
    public List<ResourceReferenceVO> findAllReferenceByBizId(@RequestParam String bizId) throws BizException {
        List<ResourceReferenceVO> vos = this.apolloResourceService.findReferenceByBizId(bizId);
        ArrayList adminIds = Lists.newArrayList();
        for (ResourceReferenceVO reference : vos) {
            adminIds.add(reference.getOperatorId());
        }
        HashMap adminInfoDtoMap = Maps.newHashMap();
        List adminInfoDtos = this.remoteAdminService.batchFindAdminInfoByIds((List)adminIds);
        for (AdminInfoDto admin : adminInfoDtos) {
            adminInfoDtoMap.put(admin.getId(), admin);
        }
        for (ResourceReferenceVO reference : vos) {
            AdminInfoDto admin = (AdminInfoDto)adminInfoDtoMap.get(reference.getOperatorId());
            reference.setOperator(admin.getName());
        }
        return Lists.reverse(vos);
    }

    @GetMapping(value={"/findResourceInstance"})
    public ResourceInstanceDTO findResourceInstance(@RequestParam Long id) {
        return this.apolloResourceService.findApolloInstance(id);
    }

    @SsoLoggerMethod(value="bizId:${bizId}\u53d1\u5e03\u8d44\u6e90${instanceId}", group="\u8d44\u6e90\u53d1\u5e03")
    @PostMapping(value={"/publishReference"})
    public JsonRender publishReference(@RequestBody @Valid PublishReferenceParams params) throws BizException {
        String accessToken = this.apolloAccessTokenService.getAccessToken();
        params.setOperator(RequestTool.getAdminId());
        this.remoteResourceReferenceService.publishReference(accessToken, params);
        ResourceReferenceDTO reference = this.remoteResourceReferenceService.findResourceReference(accessToken, params.getReferenceId());
        SsoLogger.logForPojo((Object)reference);
        return JsonRender.successResult();
    }

    @SsoLoggerMethod(value="${bizId}\u8d44\u6e90:${instanceId}\u7684\u914d\u7f6e\u53d1\u751f\u53d8\u66f4\uff0cKey:${key}", group="\u8d44\u6e90\u914d\u7f6e\u53d8\u66f4")
    @PostMapping(value={"/editReferenceItem"})
    public JsonRender editReferenceItem(@RequestBody @Valid ReferenceItemParams params) throws BizException {
        this.checkItemKeyLength(params.getKey());
        this.checkItemValueLength(params.getValue());
        String accessToken = this.apolloAccessTokenService.getAccessToken();
        KeyValue kv = new KeyValue();
        kv.setKey(params.getKey());
        kv.setValue(params.getValue());
        kv.setComment(params.getComment());
        kv.setPassword(params.getPassword().booleanValue());
        this.remoteResourceReferenceService.overrideReferenceItem(accessToken, RequestTool.getAdminId(), params.getReferenceId(), kv);
        ResourceReferenceDTO reference = this.remoteResourceReferenceService.findResourceReference(accessToken, params.getReferenceId());
        JSONObject json = new JSONObject();
        json.put("bizId", (Object)reference.getBizId());
        json.put("instanceId", (Object)reference.getInstanceId());
        json.put("key", (Object)params.getKey());
        SsoLogger.logForPojo((Object)json);
        return JsonRender.successResult();
    }

    @SsoLoggerMethod(value="${bizId}\u8d44\u6e90:${instanceId}\u7684\u914d\u7f6e\u88ab\u5220\u9664\uff0cKey:${key}", group="\u5220\u9664\u8d44\u6e90\u914d\u7f6e")
    @PostMapping(value={"/removeReferenceItem"})
    public JsonRender removeReferenceItem(@RequestBody ReferenceItemParams params) throws BizException {
        String accessToken = this.apolloAccessTokenService.getAccessToken();
        ResourceReferenceDTO reference = this.remoteResourceReferenceService.findResourceReference(accessToken, params.getReferenceId());
        if (reference == null || !reference.getActive().booleanValue()) {
            throw new BizException("\u8d44\u6e90\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        this.remoteResourceReferenceService.removeReferenceItem(accessToken, RequestTool.getAdminId(), reference.getId(), params.getKey());
        return JsonRender.successResult();
    }

    @GetMapping(value={"/findReferenceItems"})
    public ReferenceBO findReferenceItems(@RequestParam String bizId, @RequestParam Long instanceId) throws BizException {
        ReferenceBO referenceBO = this.apolloResourceService.findReferenceItems(bizId, instanceId);
        if (!referenceBO.getActive().booleanValue()) {
            return referenceBO;
        }
        List items = Optional.ofNullable(referenceBO.getReferenceView().getItems()).orElse(Collections.emptyList());
        HashSet adminIds = Sets.newHashSet();
        for (ReferenceItemViewDTO item : items) {
            adminIds.add(item.getOperator());
        }
        List adminInfoDtos = this.remoteAdminService.batchFindAdminInfoByIds((List)Lists.newArrayList((Iterable)adminIds));
        HashMap adminNames = Maps.newHashMap();
        for (AdminInfoDto adminInfoDto : adminInfoDtos) {
            adminNames.put(adminInfoDto.getId(), adminInfoDto.getName());
        }
        referenceBO.setAdminNames(adminNames);
        return referenceBO;
    }

    @GetMapping(value={"/previewTemplateRenderConfigs"})
    public List<KeyValue> previewTemplateRenderConfigs(@RequestParam Long instanceId, @RequestParam(required=false) Long templateId, @RequestParam(required=false) String instanceAlias) throws BizException {
        InstanceConfigParams params = new InstanceConfigParams();
        params.setInstanceAlias(StringUtils.trim((String)instanceAlias));
        params.setTemplateId(templateId);
        params.setInstanceId(instanceId);
        String accessToken = this.apolloAccessTokenService.getAccessToken();
        return this.remoteResourceInstanceService.previewOneInstanceConfig(accessToken, params);
    }

    private void checkItemKeyLength(String key) throws BizException {
        if (!StringUtils.isEmpty((CharSequence)key) && key.length() > 128) {
            throw new BizException("key too long. length limit:128");
        }
    }

    private void checkItemValueLength(String value) throws BizException {
        if (!StringUtils.isEmpty((CharSequence)value) && value.length() > 20000) {
            throw new BizException("value too long. length limit:20000");
        }
    }
}

