/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.ui.controller;

import cn.com.duiba.apollo.client.dto.ResourceReferenceDTO;
import cn.com.duiba.apollo.client.params.StartReferenceParams;
import cn.com.duiba.apollo.client.remoteservice.RemoteResourceReferenceService;
import cn.com.duiba.apollo.client.service.ApolloAccessTokenService;
import cn.com.duiba.apollo.ui.ApolloResourceService;
import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.sso.api.service.logger.SsoLogger;
import cn.com.duiba.sso.api.service.logger.annotation.SsoLoggerMethod;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/${duiba.sso.root-path:'/apollo'}/resourceApi"})
public class ApolloResourceController {
    @Resource
    private ApolloAccessTokenService apolloAccessTokenService;
    @Resource
    private ApolloResourceService apolloResourceService;
    @Resource
    private Environment currentEnvironment;
    @Resource
    private RemoteResourceReferenceService remoteResourceReferenceService;

    @PostMapping(value={"/applyResourceInstance/{bizId}"})
    public JsonRender applyResourceInstance(@PathVariable String bizId, @RequestBody ResourceReferenceDTO reference) throws BizException {
        Long adminId = RequestTool.getAdminId();
        reference.setOperator(adminId);
        reference.setBizId(bizId);
        this.apolloResourceService.buildApolloTranscriptRelation(reference);
        JsonRender render = JsonRender.successResult();
        if (this.currentEnvironment == Environment.DEV) {
            render.put("message", (Object)"\u8d44\u6e90\u5b9e\u4f8b\u7533\u8bf7\u6210\u529f");
        } else {
            render.put("message", (Object)"\u8d44\u6e90\u5b9e\u4f8b\u7533\u8bf7\u6210\u529f,\u7b49\u5f85\u5ba1\u6838");
        }
        return render;
    }

    @DeleteMapping(value={"/removeResourceReference/{bizId}"})
    public JsonRender removeResourceReference(@PathVariable String bizId, @RequestParam Long referenceId) throws BizException {
        String accessToken = this.apolloAccessTokenService.getAccessToken();
        ResourceReferenceDTO reference = this.remoteResourceReferenceService.findResourceReference(accessToken, referenceId);
        if (Objects.isNull(reference)) {
            throw new BizException("\u5173\u8054\u4e0d\u5b58\u5728");
        }
        if (!StringUtils.equals((CharSequence)bizId, (CharSequence)reference.getBizId())) {
            throw new BizException("\u53c2\u6570\u5f02\u5e38");
        }
        this.remoteResourceReferenceService.removeResourceReference(accessToken, RequestTool.getAdminId(), reference.getId());
        return JsonRender.successResult();
    }

    @SsoLoggerMethod(value="\u5e94\u7528:${bizId}\u542f\u7528\u8d44\u6e90${instanceId}", group="\u8d44\u6e90\u542f\u7528")
    @PostMapping(value={"/startReference/{bizId}"})
    public JsonRender startReference(@PathVariable String bizId, @RequestBody StartReferenceParams params) throws BizException {
        String accessToken = this.apolloAccessTokenService.getAccessToken();
        ResourceReferenceDTO reference = this.remoteResourceReferenceService.findResourceReference(accessToken, params.getReferenceId());
        if (Objects.isNull(reference)) {
            throw new BizException("\u5173\u8054\u4e0d\u5b58\u5728");
        }
        if (!StringUtils.equals((CharSequence)bizId, (CharSequence)reference.getBizId())) {
            throw new BizException("\u53c2\u6570\u5f02\u5e38");
        }
        this.remoteResourceReferenceService.startReference(accessToken, reference.getId(), params);
        SsoLogger.logForPojo((Object)reference);
        return JsonRender.successResult();
    }

    @SsoLoggerMethod(value="\u5e94\u7528:${bizId}\u505c\u7528\u8d44\u6e90${instanceId}", group="\u8d44\u6e90\u505c\u7528")
    @DeleteMapping(value={"/stopReference/{bizId}"})
    public JsonRender stopReference(@PathVariable String bizId, @RequestParam Long referenceId) throws BizException {
        String accessToken = this.apolloAccessTokenService.getAccessToken();
        ResourceReferenceDTO reference = this.remoteResourceReferenceService.findResourceReference(accessToken, referenceId);
        if (!StringUtils.equals((CharSequence)bizId, (CharSequence)reference.getBizId())) {
            throw new BizException("\u53c2\u6570\u5f02\u5e38");
        }
        this.remoteResourceReferenceService.stopReference(accessToken, referenceId);
        SsoLogger.logForPojo((Object)reference);
        return JsonRender.successResult();
    }
}

