define([
    "angular",
    "/apollo/js/apollo-common.js",
    "/apollo/js/apollo-resource-service.js",
    "/apollo/js/apollo-resource-directive.js",
    "less!/apollo/config.less",
], function (angular) {

    const apollo = angular.module("apollo.configuration",[
        "apollo.ui.common",
        "apollo.resource.service",
        "apollo.resource.directive"
    ]);

    apollo.service("ApolloService",ApolloService);

    const TABLE_VIEW_OPER_TYPE = {
        CREATE: 'create',
        UPDATE: 'update'
    };

    function ApolloService($uibModal,UiModel,ApolloResourceService,$q){
        /**
         * params{
         *      key:键值
         *      value:值
         *      comment:描述
         *      needSelectCluster:是否需要进行集群选择
         * }
         */
        function create(params){
            params.tableViewOperType = TABLE_VIEW_OPER_TYPE.CREATE;
            if(!!params.key){
                params.cover = true;
            }
            return openItemModel(params);
        }

        /**
         * params{
         *      key:键值
         *      value:值
         *      comment:描述
         *      needSelectCluster:是否需要进行集群选择
         * }
         */
        function edit(params) {
            params.tableViewOperType = TABLE_VIEW_OPER_TYPE.UPDATE;
            return openItemModel(params);
        }

        function openItemModel(params){
            const instance = $uibModal.open({
                size: "lg",
                animation: true,
                templateUrl: '/apollo/model/item-modal.html',
                controller: "ItemKeyValueModelController",
                backdrop: "static",
                resolve:{
                    item:function(){
                        return angular.copy(params);
                    },
                }
            });
            return instance.result;
        }

        function showText(text){
            if(!text){
                return;
            }
            $uibModal.open({
                size: "lg",
                animation: true,
                templateUrl: '/apollo/model/show-text-modal.html',
                controller: "ShowTextModalController",
                backdrop: true,
                resolve: {
                    text: function () {
                        return text;
                    }
                }
            });
        }

        function selectApolloInstance(bizId,supportTypes,title){
            const transcript = $uibModal.open({
                size: 'lg',
                animation: true,
                templateUrl: '/apollo/model/apollo-select-instances.html',
                controller: 'ApolloInstancesModelController',
                backdrop: 'static',
                resolve:{
                    modelParams:function(){
                        return {
                            types:supportTypes,
                            title:title,
                            bizId:bizId
                        }
                    }
                }
            });
            return transcript.result;
        }

        function selectTranscript(instance, title) {
            const transcript = $uibModal.open({
                size: 'lg',
                animation: true,
                templateUrl: '/apollo/model/transcript-list.html',
                controller: 'ApolloInstancesTranscriptModelController',
                backdrop: 'static',
                resolve: {
                    modelParams: function () {
                        return {
                            instance: instance,
                            title: title
                        }
                    }
                }
            });
            return transcript.result;
        }

        function preview(transcriptId, templateId, instanceAlias) {
            $uibModal.open({
                size: "full",
                animation: true,
                templateUrl: '/apollo/model/template-preview.html',
                controller: "ApolloResourceTemplatePreviewController",
                backdrop: true,
                resolve: {
                    params: function () {
                        return {
                            transcriptId: transcriptId,
                            templateId: templateId,
                            instanceAlias
                        }
                    },
                }
            });
        }

        function applyTranscript(bizId, instance) {
            const defer = $q.defer();
            selectTranscript(instance, "选择副本").then(function (transcript) {
                // 申请资源实例副本
                const p = UiModel.loading("选择中..");
                ApolloResourceService.applyResourceInstance(bizId,instance.id,transcript.id).then(function (result) {
                    p.close();
                    defer.resolve(result);
                }, function (result) {
                    p.close();
                    defer.reject(result);
                });
            })
            return defer.promise;
        }

        function applyResourceInstance(bizId) {
            const defer = $q.defer();
            selectApolloInstance(bizId, [], "选择资源")
                .then(function (result) {
                    defer.resolve(result);
                }, function (result) {
                    defer.reject(result);
                });
            return defer.promise;
        }

        function openPreViewItemsModel(items){
            const instance = $uibModal.open({
                size: "full",
                animation: true,
                templateUrl: '/apollo/model/pre-view-items.html',
                controller: "PreViewItemsController",
                backdrop: 'static',
                resolve:{
                    items:function () {
                        return items;
                    },
                }
            });
            return instance.result;
        }

        return {
            create,
            edit,
            showText,
            selectApolloInstance,
            applyResourceInstance,
            applyTranscript,
            preview,
            openPreViewItemsModel
        }
    }

});