/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.ui;

import cn.com.duiba.apollo.center.api.domain.dto.ResourceTemplateDto;
import cn.com.duiba.apollo.center.api.domain.dto.ResourceTypeDto;
import cn.com.duiba.apollo.center.api.domain.params.KeyValue;
import cn.com.duiba.apollo.center.api.remoteservice.RemoteApolloTemplateService;
import cn.com.duiba.apollo.center.api.remoteservice.RemoteResourceTypeService;
import cn.com.duiba.apollo.client.dto.ReferenceReleaseDTO;
import cn.com.duiba.apollo.client.dto.ReferenceViewDTO;
import cn.com.duiba.apollo.client.dto.ResourceInstanceDTO;
import cn.com.duiba.apollo.client.dto.ResourceInstanceTranscriptDTO;
import cn.com.duiba.apollo.client.dto.ResourceReferenceDTO;
import cn.com.duiba.apollo.client.remoteservice.RemoteResourceInstanceService;
import cn.com.duiba.apollo.client.remoteservice.RemoteResourceReferenceService;
import cn.com.duiba.apollo.client.remoteservice.RemoteResourceTranscriptService;
import cn.com.duiba.apollo.client.service.ApolloAccessTokenService;
import cn.com.duiba.apollo.client.service.resource.ResourceReferenceClientService;
import cn.com.duiba.apollo.client.utils.BeanUtils;
import cn.com.duiba.apollo.client.utils.PasswordUtils;
import cn.com.duiba.apollo.ui.vo.ReferenceBO;
import cn.com.duiba.apollo.ui.vo.ResourceReferenceVO;
import cn.com.duiba.boot.exception.BizException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Resource;

public class ApolloResourceService {
    @Resource
    private RemoteResourceInstanceService remoteResourceInstanceService;
    @Resource
    private ApolloAccessTokenService apolloAccessTokenService;
    @Resource
    private RemoteResourceReferenceService remoteResourceReferenceService;
    @Resource
    private ResourceReferenceClientService resourceReferenceClientService;
    @Resource
    private RemoteResourceTypeService remoteResourceTypeService;
    @Resource
    private RemoteApolloTemplateService remoteApolloTemplateService;
    @Resource
    private RemoteResourceTranscriptService remoteResourceTranscriptService;

    public List<ResourceReferenceVO> findReferenceByBizId(String bizId) throws BizException {
        String accessToken = this.apolloAccessTokenService.getAccessToken();
        List references = this.remoteResourceReferenceService.findResourceReferenceByBizId(accessToken, bizId);
        if (references.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList instanceIds = Lists.newArrayList();
        ArrayList transcriptIds = Lists.newArrayList();
        ArrayList templateIds = Lists.newArrayList();
        ArrayList sources = Lists.newArrayList();
        for (ResourceReferenceDTO reference : references) {
            sources.add(reference);
            instanceIds.add(reference.getInstanceId());
            transcriptIds.add(reference.getTranscriptId());
            templateIds.add(reference.getTemplateId());
        }
        List resourceTypes = this.remoteResourceTypeService.findAllTypes();
        Map resourceTypeMap = BeanUtils.mapByKey((String)"type", (List)resourceTypes);
        List instances = this.remoteResourceInstanceService.findInstancesByIds((List)instanceIds);
        HashMap instanceMap = Maps.newHashMap();
        for (ResourceInstanceDTO instance : instances) {
            instanceMap.put(instance.getId(), instance);
        }
        List transcripts = this.remoteResourceTranscriptService.findAllByTranscriptIds((List)transcriptIds);
        HashMap transcriptMap = Maps.newHashMap();
        for (ResourceInstanceTranscriptDTO transcript : transcripts) {
            transcriptMap.put(transcript.getId(), transcript);
        }
        HashMap templateMap = Maps.newHashMap();
        if (!templateIds.isEmpty()) {
            List templates = this.remoteApolloTemplateService.findResourceTemplateByIds((List)templateIds);
            for (ResourceTemplateDto template : templates) {
                templateMap.put(template.getId(), template);
            }
        }
        ArrayList result = Lists.newArrayList();
        for (ResourceReferenceDTO reference : sources) {
            ResourceInstanceTranscriptDTO transcript;
            ResourceReferenceVO vo = new ResourceReferenceVO();
            vo.setId(reference.getId());
            vo.setBizId(reference.getBizId());
            vo.setInstanceId(reference.getInstanceId());
            vo.setTemplateId(reference.getTemplateId());
            vo.setActive(reference.getActive());
            vo.setInstanceAlias(reference.getInstanceAlias());
            vo.setOperatorId(reference.getOperator());
            ResourceInstanceDTO instance = (ResourceInstanceDTO)instanceMap.get(reference.getInstanceId());
            if (Objects.nonNull(instance)) {
                vo.setInstanceKey(instance.getKey());
                vo.setInstanceName(instance.getName());
                vo.setType(instance.getType());
                ResourceTypeDto resourceType = (ResourceTypeDto)resourceTypeMap.get(instance.getType());
                vo.setTypeName(resourceType.getName());
            }
            if (Objects.nonNull(transcript = (ResourceInstanceTranscriptDTO)transcriptMap.get(reference.getTranscriptId()))) {
                vo.setTranscriptName(transcript.getTranscriptName());
            }
            if (Objects.nonNull(reference.getTemplateId())) {
                ResourceTemplateDto template = (ResourceTemplateDto)templateMap.get(reference.getTemplateId());
                vo.setTemplateName(template.getName());
            }
            vo.setAuthorized(reference.getAuthorized());
            vo.setTranscriptId(reference.getTranscriptId());
            result.add(vo);
        }
        return result;
    }

    public List<ResourceInstanceDTO> findApolloInstances(Collection<Long> ids) {
        return this.remoteResourceInstanceService.findInstancesByIds((List)Lists.newArrayList(ids));
    }

    public ResourceInstanceDTO findApolloInstance(Long instanceId) {
        return this.remoteResourceInstanceService.findOneInstance(instanceId);
    }

    public Properties findApolloTranscriptConfig(Long transcriptId) throws BizException {
        List keyValues = this.remoteResourceInstanceService.findTranscriptNativeConfig(transcriptId);
        Properties instanceConfigs = new Properties();
        for (KeyValue kv : keyValues) {
            instanceConfigs.put(kv.getKey(), kv.getValue());
        }
        return instanceConfigs;
    }

    public ReferenceBO findReferenceItemsByTranscriptId(String bizId, Long transcriptId) throws BizException {
        String accessToken = this.apolloAccessTokenService.getAccessToken();
        ResourceReferenceDTO reference = this.remoteResourceReferenceService.findReferenceByBizIdAndTranscriptId(accessToken, bizId, transcriptId);
        if (reference == null) {
            return null;
        }
        ReferenceBO result = new ReferenceBO();
        result.setReferenceId(reference.getId());
        result.setAuthorized(reference.getAuthorized());
        result.setActive(reference.getActive());
        if (!reference.getAuthorized().booleanValue() || !reference.getActive().booleanValue()) {
            return result;
        }
        ReferenceViewDTO referenceView = this.remoteResourceReferenceService.findReferenceView(accessToken, reference.getId());
        result.setReferenceView(referenceView);
        return result;
    }

    public String charkInstanceType(Long instanceId, Set<String> supportTypes) throws BizException {
        ResourceInstanceDTO instance = this.remoteResourceInstanceService.findOneInstance(instanceId);
        Objects.requireNonNull(instance);
        return this.charkInstanceType(instance, supportTypes);
    }

    public String charkInstanceType(ResourceInstanceDTO instance, Set<String> supportTypes) throws BizException {
        ResourceTypeDto resourceType = this.remoteResourceTypeService.findByType(instance.getType());
        Objects.requireNonNull(resourceType);
        if (!supportTypes.contains(resourceType.getType())) {
            throw new BizException("\u4e0d\u652f\u6301\u8bbe\u7f6e[" + resourceType.getName() + "]\u7c7b\u578b\u7684\u8d44\u6e90\u5b9e\u4f8b");
        }
        return resourceType.getType();
    }

    public void buildApolloTranscriptRelation(ResourceReferenceDTO params) throws BizException {
        String accessToken = this.apolloAccessTokenService.getAccessToken();
        ResourceReferenceDTO reference = this.remoteResourceReferenceService.findReferenceByBizIdAndTranscriptId(accessToken, params.getBizId(), params.getTranscriptId());
        if (Objects.nonNull(reference)) {
            return;
        }
        this.remoteResourceReferenceService.applyResourceInstance(accessToken, params);
    }

    public void deleteReferenceByTranscriptId(String bizId, Long transcriptId, Long operator) throws BizException {
        String accessToken = this.apolloAccessTokenService.getAccessToken();
        ResourceReferenceDTO reference = this.remoteResourceReferenceService.findReferenceByBizIdAndTranscriptId(accessToken, bizId, transcriptId);
        if (Objects.isNull(reference)) {
            return;
        }
        if (reference.getActive().booleanValue()) {
            this.remoteResourceReferenceService.stopReference(accessToken, reference.getId());
        }
        this.remoteResourceReferenceService.removeResourceReference(accessToken, operator, reference.getId());
    }

    public ResourceReferenceDTO findResourceReferenceByTranscriptId(String bizId, Long transcriptId) throws BizException {
        String accessToken = this.apolloAccessTokenService.getAccessToken();
        return this.remoteResourceReferenceService.findReferenceByBizIdAndTranscriptId(accessToken, bizId, transcriptId);
    }

    public Properties findCanalInstanceConfigByTranscriptId(String bizId, Long transcriptId) throws BizException {
        ResourceReferenceDTO reference = this.findResourceReferenceByTranscriptId(bizId, transcriptId);
        if (!reference.getActive().booleanValue()) {
            throw new BizException("Apollo\u5b9e\u4f8b\u914d\u7f6e\u672a\u6fc0\u6d3b");
        }
        ReferenceReleaseDTO referenceRelease = this.resourceReferenceClientService.findReferenceProperties(reference.getId());
        Properties properties = referenceRelease.getReleaseProperties();
        Properties resultProperties = new Properties();
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            resultProperties.put(key, PasswordUtils.decryptValue((String)value));
        }
        return resultProperties;
    }
}

